package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ModelPackageArn, RoleArn, EntityName}
import scala.jdk.CollectionConverters.*
final case class CreateCompilationJobRequest(
    compilationJobName: EntityName,
    roleArn: RoleArn,
    modelPackageVersionArn: Option[ModelPackageArn] = None,
    inputConfig: Option[zio.aws.sagemaker.model.InputConfig] = None,
    outputConfig: zio.aws.sagemaker.model.OutputConfig,
    vpcConfig: Option[zio.aws.sagemaker.model.NeoVpcConfig] = None,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest = {
    import CreateCompilationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest
      .builder()
      .compilationJobName(
        EntityName.unwrap(compilationJobName): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        modelPackageVersionArn.map(value =>
          ModelPackageArn.unwrap(value): java.lang.String
        )
      )(_.modelPackageVersionArn)
      .optionallyWith(inputConfig.map(value => value.buildAwsValue()))(
        _.inputConfig
      )
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateCompilationJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateCompilationJobRequest.wrap(buildAwsValue())
}
object CreateCompilationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateCompilationJobRequest =
      zio.aws.sagemaker.model.CreateCompilationJobRequest(
        compilationJobName,
        roleArn,
        modelPackageVersionArn.map(value => value),
        inputConfig.map(value => value.asEditable),
        outputConfig.asEditable,
        vpcConfig.map(value => value.asEditable),
        stoppingCondition.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compilationJobName: EntityName
    def roleArn: RoleArn
    def modelPackageVersionArn: Option[ModelPackageArn]
    def inputConfig: Option[zio.aws.sagemaker.model.InputConfig.ReadOnly]
    def outputConfig: zio.aws.sagemaker.model.OutputConfig.ReadOnly
    def vpcConfig: Option[zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly]
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getCompilationJobName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(compilationJobName)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getModelPackageVersionArn: ZIO[Any, AwsError, ModelPackageArn] =
      AwsError.unwrapOptionField(
        "modelPackageVersionArn",
        modelPackageVersionArn
      )
    def getInputConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.InputConfig.ReadOnly] =
      AwsError.unwrapOptionField("inputConfig", inputConfig)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest
  ) extends zio.aws.sagemaker.model.CreateCompilationJobRequest.ReadOnly {
    override val compilationJobName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.compilationJobName())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val modelPackageVersionArn: Option[ModelPackageArn] = scala
      .Option(impl.modelPackageVersionArn())
      .map(value => zio.aws.sagemaker.model.primitives.ModelPackageArn(value))
    override val inputConfig
        : Option[zio.aws.sagemaker.model.InputConfig.ReadOnly] = scala
      .Option(impl.inputConfig())
      .map(value => zio.aws.sagemaker.model.InputConfig.wrap(value))
    override val outputConfig: zio.aws.sagemaker.model.OutputConfig.ReadOnly =
      zio.aws.sagemaker.model.OutputConfig.wrap(impl.outputConfig())
    override val vpcConfig
        : Option[zio.aws.sagemaker.model.NeoVpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.sagemaker.model.NeoVpcConfig.wrap(value))
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest
  ): zio.aws.sagemaker.model.CreateCompilationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
