package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.AppArn
import scala.jdk.CollectionConverters.*
final case class CreateAppResponse(appArn: Option[AppArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAppResponse = {
    import CreateAppResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAppResponse
      .builder()
      .optionallyWith(
        appArn.map(value => AppArn.unwrap(value): java.lang.String)
      )(_.appArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAppResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateAppResponse.wrap(buildAwsValue())
}
object CreateAppResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAppResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAppResponse =
      zio.aws.sagemaker.model.CreateAppResponse(appArn.map(value => value))
    def appArn: Option[AppArn]
    def getAppArn: ZIO[Any, AwsError, AppArn] =
      AwsError.unwrapOptionField("appArn", appArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppResponse
  ) extends zio.aws.sagemaker.model.CreateAppResponse.ReadOnly {
    override val appArn: Option[AppArn] = scala
      .Option(impl.appArn())
      .map(value => zio.aws.sagemaker.model.primitives.AppArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppResponse
  ): zio.aws.sagemaker.model.CreateAppResponse.ReadOnly = new Wrapper(impl)
}
