package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{AppName, UserProfileName, DomainId}
import scala.jdk.CollectionConverters.*
final case class CreateAppRequest(
    domainId: DomainId,
    userProfileName: UserProfileName,
    appType: zio.aws.sagemaker.model.AppType,
    appName: AppName,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    resourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateAppRequest = {
    import CreateAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
      .builder()
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .userProfileName(
        UserProfileName.unwrap(userProfileName): java.lang.String
      )
      .appType(appType.unwrap)
      .appName(AppName.unwrap(appName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(resourceSpec.map(value => value.buildAwsValue()))(
        _.resourceSpec
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateAppRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateAppRequest.wrap(buildAwsValue())
}
object CreateAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateAppRequest =
      zio.aws.sagemaker.model.CreateAppRequest(
        domainId,
        userProfileName,
        appType,
        appName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceSpec.map(value => value.asEditable)
      )
    def domainId: DomainId
    def userProfileName: UserProfileName
    def appType: zio.aws.sagemaker.model.AppType
    def appName: AppName
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def resourceSpec: Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly]
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getUserProfileName: ZIO[Any, Nothing, UserProfileName] =
      ZIO.succeed(userProfileName)
    def getAppType: ZIO[Any, Nothing, zio.aws.sagemaker.model.AppType] =
      ZIO.succeed(appType)
    def getAppName: ZIO[Any, Nothing, AppName] = ZIO.succeed(appName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceSpec
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ResourceSpec.ReadOnly] =
      AwsError.unwrapOptionField("resourceSpec", resourceSpec)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ) extends zio.aws.sagemaker.model.CreateAppRequest.ReadOnly {
    override val domainId: DomainId =
      zio.aws.sagemaker.model.primitives.DomainId(impl.domainId())
    override val userProfileName: UserProfileName =
      zio.aws.sagemaker.model.primitives.UserProfileName(impl.userProfileName())
    override val appType: zio.aws.sagemaker.model.AppType =
      zio.aws.sagemaker.model.AppType.wrap(impl.appType())
    override val appName: AppName =
      zio.aws.sagemaker.model.primitives.AppName(impl.appName())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val resourceSpec
        : Option[zio.aws.sagemaker.model.ResourceSpec.ReadOnly] = scala
      .Option(impl.resourceSpec())
      .map(value => zio.aws.sagemaker.model.ResourceSpec.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateAppRequest
  ): zio.aws.sagemaker.model.CreateAppRequest.ReadOnly = new Wrapper(impl)
}
