package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConditionStepMetadata(
    outcome: Option[zio.aws.sagemaker.model.ConditionOutcome] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata = {
    import ConditionStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata
      .builder()
      .optionallyWith(outcome.map(value => value.unwrap))(_.outcome)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.ConditionStepMetadata.wrap(buildAwsValue())
}
object ConditionStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ConditionStepMetadata =
      zio.aws.sagemaker.model.ConditionStepMetadata(outcome.map(value => value))
    def outcome: Option[zio.aws.sagemaker.model.ConditionOutcome]
    def getOutcome
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ConditionOutcome] =
      AwsError.unwrapOptionField("outcome", outcome)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata
  ) extends zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly {
    override val outcome: Option[zio.aws.sagemaker.model.ConditionOutcome] =
      scala
        .Option(impl.outcome())
        .map(value => zio.aws.sagemaker.model.ConditionOutcome.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ConditionStepMetadata
  ): zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly = new Wrapper(impl)
}
