package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait CapacitySizeType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.CapacitySizeType
}
object CapacitySizeType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.CapacitySizeType
  ): zio.aws.sagemaker.model.CapacitySizeType = value match {
    case software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.INSTANCE_COUNT =>
      val r = INSTANCE_COUNT
      r
    case software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.CAPACITY_PERCENT =>
      val r = CAPACITY_PERCENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.CapacitySizeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CapacitySizeType =
      software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSTANCE_COUNT extends zio.aws.sagemaker.model.CapacitySizeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CapacitySizeType =
      software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.INSTANCE_COUNT
  }
  case object CAPACITY_PERCENT
      extends zio.aws.sagemaker.model.CapacitySizeType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.CapacitySizeType =
      software.amazon.awssdk.services.sagemaker.model.CapacitySizeType.CAPACITY_PERCENT
  }
}
