package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  ModelInsightsLocation,
  ExplainabilityLocation
}
import scala.jdk.CollectionConverters.*
final case class CandidateArtifactLocations(
    explainability: ExplainabilityLocation,
    modelInsights: Option[ModelInsightsLocation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations = {
    import CandidateArtifactLocations.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
      .builder()
      .explainability(
        ExplainabilityLocation.unwrap(explainability): java.lang.String
      )
      .optionallyWith(
        modelInsights.map(value =>
          ModelInsightsLocation.unwrap(value): java.lang.String
        )
      )(_.modelInsights)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly =
    zio.aws.sagemaker.model.CandidateArtifactLocations.wrap(buildAwsValue())
}
object CandidateArtifactLocations {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CandidateArtifactLocations =
      zio.aws.sagemaker.model.CandidateArtifactLocations(
        explainability,
        modelInsights.map(value => value)
      )
    def explainability: ExplainabilityLocation
    def modelInsights: Option[ModelInsightsLocation]
    def getExplainability: ZIO[Any, Nothing, ExplainabilityLocation] =
      ZIO.succeed(explainability)
    def getModelInsights: ZIO[Any, AwsError, ModelInsightsLocation] =
      AwsError.unwrapOptionField("modelInsights", modelInsights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ) extends zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly {
    override val explainability: ExplainabilityLocation =
      zio.aws.sagemaker.model.primitives
        .ExplainabilityLocation(impl.explainability())
    override val modelInsights: Option[ModelInsightsLocation] = scala
      .Option(impl.modelInsights())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ModelInsightsLocation(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CandidateArtifactLocations
  ): zio.aws.sagemaker.model.CandidateArtifactLocations.ReadOnly = new Wrapper(
    impl
  )
}
