package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ContentType, TargetAttributeName}
import scala.jdk.CollectionConverters.*
final case class AutoMLChannel(
    dataSource: zio.aws.sagemaker.model.AutoMLDataSource,
    compressionType: Option[zio.aws.sagemaker.model.CompressionType] = None,
    targetAttributeName: TargetAttributeName,
    contentType: Option[ContentType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AutoMLChannel = {
    import AutoMLChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AutoMLChannel
      .builder()
      .dataSource(dataSource.buildAwsValue())
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .targetAttributeName(
        TargetAttributeName.unwrap(targetAttributeName): java.lang.String
      )
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AutoMLChannel.ReadOnly =
    zio.aws.sagemaker.model.AutoMLChannel.wrap(buildAwsValue())
}
object AutoMLChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AutoMLChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AutoMLChannel =
      zio.aws.sagemaker.model.AutoMLChannel(
        dataSource.asEditable,
        compressionType.map(value => value),
        targetAttributeName,
        contentType.map(value => value)
      )
    def dataSource: zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly
    def compressionType: Option[zio.aws.sagemaker.model.CompressionType]
    def targetAttributeName: TargetAttributeName
    def contentType: Option[ContentType]
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly] =
      ZIO.succeed(dataSource)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getTargetAttributeName: ZIO[Any, Nothing, TargetAttributeName] =
      ZIO.succeed(targetAttributeName)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLChannel
  ) extends zio.aws.sagemaker.model.AutoMLChannel.ReadOnly {
    override val dataSource: zio.aws.sagemaker.model.AutoMLDataSource.ReadOnly =
      zio.aws.sagemaker.model.AutoMLDataSource.wrap(impl.dataSource())
    override val compressionType
        : Option[zio.aws.sagemaker.model.CompressionType] = scala
      .Option(impl.compressionType())
      .map(value => zio.aws.sagemaker.model.CompressionType.wrap(value))
    override val targetAttributeName: TargetAttributeName =
      zio.aws.sagemaker.model.primitives
        .TargetAttributeName(impl.targetAttributeName())
    override val contentType: Option[ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.sagemaker.model.primitives.ContentType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AutoMLChannel
  ): zio.aws.sagemaker.model.AutoMLChannel.ReadOnly = new Wrapper(impl)
}
