package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AlgorithmStatusDetails(
    validationStatuses: Option[
      Iterable[zio.aws.sagemaker.model.AlgorithmStatusItem]
    ] = None,
    imageScanStatuses: Option[
      Iterable[zio.aws.sagemaker.model.AlgorithmStatusItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails = {
    import AlgorithmStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails
      .builder()
      .optionallyWith(
        validationStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationStatuses)
      .optionallyWith(
        imageScanStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageScanStatuses)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmStatusDetails.wrap(buildAwsValue())
}
object AlgorithmStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmStatusDetails =
      zio.aws.sagemaker.model.AlgorithmStatusDetails(
        validationStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageScanStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def validationStatuses
        : Option[List[zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly]]
    def imageScanStatuses
        : Option[List[zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly]]
    def getValidationStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly
    ]] = AwsError.unwrapOptionField("validationStatuses", validationStatuses)
    def getImageScanStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly
    ]] = AwsError.unwrapOptionField("imageScanStatuses", imageScanStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails
  ) extends zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly {
    override val validationStatuses
        : Option[List[zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly]] =
      scala
        .Option(impl.validationStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AlgorithmStatusItem.wrap(item)
          }.toList
        )
    override val imageScanStatuses
        : Option[List[zio.aws.sagemaker.model.AlgorithmStatusItem.ReadOnly]] =
      scala
        .Option(impl.imageScanStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.AlgorithmStatusItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmStatusDetails
  ): zio.aws.sagemaker.model.AlgorithmStatusDetails.ReadOnly = new Wrapper(impl)
}
