package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  WorkteamName,
  WorkteamArn,
  Timestamp,
  WorkforceArn,
  String200
}
import scala.jdk.CollectionConverters.*
final case class Workteam(
    workteamName: WorkteamName,
    memberDefinitions: Iterable[zio.aws.sagemaker.model.MemberDefinition],
    workteamArn: WorkteamArn,
    workforceArn: Option[WorkforceArn] = None,
    productListingIds: Option[Iterable[String]] = None,
    description: String200,
    subDomain: Option[String] = None,
    createDate: Option[Timestamp] = None,
    lastUpdatedDate: Option[Timestamp] = None,
    notificationConfiguration: Option[
      zio.aws.sagemaker.model.NotificationConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.Workteam = {
    import Workteam.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Workteam
      .builder()
      .workteamName(WorkteamName.unwrap(workteamName): java.lang.String)
      .memberDefinitions(memberDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .workteamArn(WorkteamArn.unwrap(workteamArn): java.lang.String)
      .optionallyWith(
        workforceArn.map(value => WorkforceArn.unwrap(value): java.lang.String)
      )(_.workforceArn)
      .optionallyWith(
        productListingIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productListingIds)
      .description(String200.unwrap(description): java.lang.String)
      .optionallyWith(subDomain.map(value => value: java.lang.String))(
        _.subDomain
      )
      .optionallyWith(
        createDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(
        lastUpdatedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedDate)
      .optionallyWith(
        notificationConfiguration.map(value => value.buildAwsValue())
      )(_.notificationConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Workteam.ReadOnly =
    zio.aws.sagemaker.model.Workteam.wrap(buildAwsValue())
}
object Workteam {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.Workteam
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Workteam =
      zio.aws.sagemaker.model.Workteam(
        workteamName,
        memberDefinitions.map { item =>
          item.asEditable
        },
        workteamArn,
        workforceArn.map(value => value),
        productListingIds.map(value => value),
        description,
        subDomain.map(value => value),
        createDate.map(value => value),
        lastUpdatedDate.map(value => value),
        notificationConfiguration.map(value => value.asEditable)
      )
    def workteamName: WorkteamName
    def memberDefinitions
        : List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly]
    def workteamArn: WorkteamArn
    def workforceArn: Option[WorkforceArn]
    def productListingIds: Option[List[String]]
    def description: String200
    def subDomain: Option[String]
    def createDate: Option[Timestamp]
    def lastUpdatedDate: Option[Timestamp]
    def notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly]
    def getWorkteamName: ZIO[Any, Nothing, WorkteamName] =
      ZIO.succeed(workteamName)
    def getMemberDefinitions: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MemberDefinition.ReadOnly
    ]] = ZIO.succeed(memberDefinitions)
    def getWorkteamArn: ZIO[Any, Nothing, WorkteamArn] =
      ZIO.succeed(workteamArn)
    def getWorkforceArn: ZIO[Any, AwsError, WorkforceArn] =
      AwsError.unwrapOptionField("workforceArn", workforceArn)
    def getProductListingIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productListingIds", productListingIds)
    def getDescription: ZIO[Any, Nothing, String200] = ZIO.succeed(description)
    def getSubDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subDomain", subDomain)
    def getCreateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getLastUpdatedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedDate", lastUpdatedDate)
    def getNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "notificationConfiguration",
      notificationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Workteam
  ) extends zio.aws.sagemaker.model.Workteam.ReadOnly {
    override val workteamName: WorkteamName =
      zio.aws.sagemaker.model.primitives.WorkteamName(impl.workteamName())
    override val memberDefinitions
        : List[zio.aws.sagemaker.model.MemberDefinition.ReadOnly] = impl
      .memberDefinitions()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.MemberDefinition.wrap(item)
      }
      .toList
    override val workteamArn: WorkteamArn =
      zio.aws.sagemaker.model.primitives.WorkteamArn(impl.workteamArn())
    override val workforceArn: Option[WorkforceArn] = scala
      .Option(impl.workforceArn())
      .map(value => zio.aws.sagemaker.model.primitives.WorkforceArn(value))
    override val productListingIds: Option[List[String]] = scala
      .Option(impl.productListingIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val description: String200 =
      zio.aws.sagemaker.model.primitives.String200(impl.description())
    override val subDomain: Option[String] =
      scala.Option(impl.subDomain()).map(value => value: String)
    override val createDate: Option[Timestamp] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastUpdatedDate: Option[Timestamp] = scala
      .Option(impl.lastUpdatedDate())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val notificationConfiguration
        : Option[zio.aws.sagemaker.model.NotificationConfiguration.ReadOnly] =
      scala
        .Option(impl.notificationConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.NotificationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Workteam
  ): zio.aws.sagemaker.model.Workteam.ReadOnly = new Wrapper(impl)
}
