package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class VariantProperty(
    variantPropertyType: zio.aws.sagemaker.model.VariantPropertyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.VariantProperty = {
    import VariantProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.VariantProperty
      .builder()
      .variantPropertyType(variantPropertyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.VariantProperty.ReadOnly =
    zio.aws.sagemaker.model.VariantProperty.wrap(buildAwsValue())
}
object VariantProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.VariantProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.VariantProperty =
      zio.aws.sagemaker.model.VariantProperty(variantPropertyType)
    def variantPropertyType: zio.aws.sagemaker.model.VariantPropertyType
    def getVariantPropertyType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.VariantPropertyType] =
      ZIO.succeed(variantPropertyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.VariantProperty
  ) extends zio.aws.sagemaker.model.VariantProperty.ReadOnly {
    override val variantPropertyType
        : zio.aws.sagemaker.model.VariantPropertyType =
      zio.aws.sagemaker.model.VariantPropertyType
        .wrap(impl.variantPropertyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.VariantProperty
  ): zio.aws.sagemaker.model.VariantProperty.ReadOnly = new Wrapper(impl)
}
