package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.PipelineArn
import scala.jdk.CollectionConverters.*
final case class UpdatePipelineResponse(
    pipelineArn: Option[PipelineArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse = {
    import UpdatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse
      .builder()
      .optionallyWith(
        pipelineArn.map(value => PipelineArn.unwrap(value): java.lang.String)
      )(_.pipelineArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdatePipelineResponse.wrap(buildAwsValue())
}
object UpdatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdatePipelineResponse =
      zio.aws.sagemaker.model
        .UpdatePipelineResponse(pipelineArn.map(value => value))
    def pipelineArn: Option[PipelineArn]
    def getPipelineArn: ZIO[Any, AwsError, PipelineArn] =
      AwsError.unwrapOptionField("pipelineArn", pipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse
  ) extends zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly {
    override val pipelineArn: Option[PipelineArn] = scala
      .Option(impl.pipelineArn())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse
  ): zio.aws.sagemaker.model.UpdatePipelineResponse.ReadOnly = new Wrapper(impl)
}
