package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ContextArn
import scala.jdk.CollectionConverters.*
final case class UpdateContextResponse(contextArn: Option[ContextArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse = {
    import UpdateContextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse
      .builder()
      .optionallyWith(
        contextArn.map(value => ContextArn.unwrap(value): java.lang.String)
      )(_.contextArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly =
    zio.aws.sagemaker.model.UpdateContextResponse.wrap(buildAwsValue())
}
object UpdateContextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateContextResponse =
      zio.aws.sagemaker.model
        .UpdateContextResponse(contextArn.map(value => value))
    def contextArn: Option[ContextArn]
    def getContextArn: ZIO[Any, AwsError, ContextArn] =
      AwsError.unwrapOptionField("contextArn", contextArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse
  ) extends zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly {
    override val contextArn: Option[ContextArn] = scala
      .Option(impl.contextArn())
      .map(value => zio.aws.sagemaker.model.primitives.ContextArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse
  ): zio.aws.sagemaker.model.UpdateContextResponse.ReadOnly = new Wrapper(impl)
}
