package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{SourceType, TrialComponentSourceArn}
import scala.jdk.CollectionConverters.*
final case class TrialComponentSource(
    sourceArn: TrialComponentSourceArn,
    sourceType: Option[SourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSource = {
    import TrialComponentSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSource
      .builder()
      .sourceArn(TrialComponentSourceArn.unwrap(sourceArn): java.lang.String)
      .optionallyWith(
        sourceType.map(value => SourceType.unwrap(value): java.lang.String)
      )(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSource.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSource.wrap(buildAwsValue())
}
object TrialComponentSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSource =
      zio.aws.sagemaker.model
        .TrialComponentSource(sourceArn, sourceType.map(value => value))
    def sourceArn: TrialComponentSourceArn
    def sourceType: Option[SourceType]
    def getSourceArn: ZIO[Any, Nothing, TrialComponentSourceArn] =
      ZIO.succeed(sourceArn)
    def getSourceType: ZIO[Any, AwsError, SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSource
  ) extends zio.aws.sagemaker.model.TrialComponentSource.ReadOnly {
    override val sourceArn: TrialComponentSourceArn =
      zio.aws.sagemaker.model.primitives
        .TrialComponentSourceArn(impl.sourceArn())
    override val sourceType: Option[SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.sagemaker.model.primitives.SourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSource
  ): zio.aws.sagemaker.model.TrialComponentSource.ReadOnly = new Wrapper(impl)
}
