package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TrialComponentArtifactValue,
  MediaType
}
import scala.jdk.CollectionConverters.*
final case class TrialComponentArtifact(
    mediaType: Option[MediaType] = None,
    value: TrialComponentArtifactValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact = {
    import TrialComponentArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact
      .builder()
      .optionallyWith(
        mediaType.map(value => MediaType.unwrap(value): java.lang.String)
      )(_.mediaType)
      .value(TrialComponentArtifactValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentArtifact.wrap(buildAwsValue())
}
object TrialComponentArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentArtifact =
      zio.aws.sagemaker.model
        .TrialComponentArtifact(mediaType.map(value => value), value)
    def mediaType: Option[MediaType]
    def value: TrialComponentArtifactValue
    def getMediaType: ZIO[Any, AwsError, MediaType] =
      AwsError.unwrapOptionField("mediaType", mediaType)
    def getValue: ZIO[Any, Nothing, TrialComponentArtifactValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact
  ) extends zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly {
    override val mediaType: Option[MediaType] = scala
      .Option(impl.mediaType())
      .map(value => zio.aws.sagemaker.model.primitives.MediaType(value))
    override val value: TrialComponentArtifactValue =
      zio.aws.sagemaker.model.primitives
        .TrialComponentArtifactValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact
  ): zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly = new Wrapper(impl)
}
