package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TransformJobArn,
  LabelingJobArn,
  Timestamp,
  FailureReason,
  TransformEnvironmentValue,
  MaxConcurrentTransforms,
  TransformEnvironmentKey,
  MaxPayloadInMB,
  ModelName,
  AutoMLJobArn,
  TransformJobName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TransformJob(
    transformJobName: Option[TransformJobName] = None,
    transformJobArn: Option[TransformJobArn] = None,
    transformJobStatus: Option[zio.aws.sagemaker.model.TransformJobStatus] =
      None,
    failureReason: Option[FailureReason] = None,
    modelName: Option[ModelName] = None,
    maxConcurrentTransforms: Option[MaxConcurrentTransforms] = None,
    modelClientConfig: Option[zio.aws.sagemaker.model.ModelClientConfig] = None,
    maxPayloadInMB: Option[MaxPayloadInMB] = None,
    batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy] = None,
    environment: Option[
      Map[TransformEnvironmentKey, TransformEnvironmentValue]
    ] = None,
    transformInput: Option[zio.aws.sagemaker.model.TransformInput] = None,
    transformOutput: Option[zio.aws.sagemaker.model.TransformOutput] = None,
    transformResources: Option[zio.aws.sagemaker.model.TransformResources] =
      None,
    creationTime: Option[Timestamp] = None,
    transformStartTime: Option[Timestamp] = None,
    transformEndTime: Option[Timestamp] = None,
    labelingJobArn: Option[LabelingJobArn] = None,
    autoMLJobArn: Option[AutoMLJobArn] = None,
    dataProcessing: Option[zio.aws.sagemaker.model.DataProcessing] = None,
    experimentConfig: Option[zio.aws.sagemaker.model.ExperimentConfig] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformJob = {
    import TransformJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformJob
      .builder()
      .optionallyWith(
        transformJobName.map(value =>
          TransformJobName.unwrap(value): java.lang.String
        )
      )(_.transformJobName)
      .optionallyWith(
        transformJobArn.map(value =>
          TransformJobArn.unwrap(value): java.lang.String
        )
      )(_.transformJobArn)
      .optionallyWith(transformJobStatus.map(value => value.unwrap))(
        _.transformJobStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        modelName.map(value => ModelName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        maxConcurrentTransforms.map(value =>
          MaxConcurrentTransforms.unwrap(value): Integer
        )
      )(_.maxConcurrentTransforms)
      .optionallyWith(modelClientConfig.map(value => value.buildAwsValue()))(
        _.modelClientConfig
      )
      .optionallyWith(
        maxPayloadInMB.map(value => MaxPayloadInMB.unwrap(value): Integer)
      )(_.maxPayloadInMB)
      .optionallyWith(batchStrategy.map(value => value.unwrap))(_.batchStrategy)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TransformEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (TransformEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(transformInput.map(value => value.buildAwsValue()))(
        _.transformInput
      )
      .optionallyWith(transformOutput.map(value => value.buildAwsValue()))(
        _.transformOutput
      )
      .optionallyWith(transformResources.map(value => value.buildAwsValue()))(
        _.transformResources
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        transformStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transformStartTime)
      .optionallyWith(
        transformEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transformEndTime)
      .optionallyWith(
        labelingJobArn.map(value =>
          LabelingJobArn.unwrap(value): java.lang.String
        )
      )(_.labelingJobArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .optionallyWith(dataProcessing.map(value => value.buildAwsValue()))(
        _.dataProcessing
      )
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformJob.ReadOnly =
    zio.aws.sagemaker.model.TransformJob.wrap(buildAwsValue())
}
object TransformJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformJob =
      zio.aws.sagemaker.model.TransformJob(
        transformJobName.map(value => value),
        transformJobArn.map(value => value),
        transformJobStatus.map(value => value),
        failureReason.map(value => value),
        modelName.map(value => value),
        maxConcurrentTransforms.map(value => value),
        modelClientConfig.map(value => value.asEditable),
        maxPayloadInMB.map(value => value),
        batchStrategy.map(value => value),
        environment.map(value => value),
        transformInput.map(value => value.asEditable),
        transformOutput.map(value => value.asEditable),
        transformResources.map(value => value.asEditable),
        creationTime.map(value => value),
        transformStartTime.map(value => value),
        transformEndTime.map(value => value),
        labelingJobArn.map(value => value),
        autoMLJobArn.map(value => value),
        dataProcessing.map(value => value.asEditable),
        experimentConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transformJobName: Option[TransformJobName]
    def transformJobArn: Option[TransformJobArn]
    def transformJobStatus: Option[zio.aws.sagemaker.model.TransformJobStatus]
    def failureReason: Option[FailureReason]
    def modelName: Option[ModelName]
    def maxConcurrentTransforms: Option[MaxConcurrentTransforms]
    def modelClientConfig
        : Option[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly]
    def maxPayloadInMB: Option[MaxPayloadInMB]
    def batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy]
    def environment
        : Option[Map[TransformEnvironmentKey, TransformEnvironmentValue]]
    def transformInput: Option[zio.aws.sagemaker.model.TransformInput.ReadOnly]
    def transformOutput
        : Option[zio.aws.sagemaker.model.TransformOutput.ReadOnly]
    def transformResources
        : Option[zio.aws.sagemaker.model.TransformResources.ReadOnly]
    def creationTime: Option[Timestamp]
    def transformStartTime: Option[Timestamp]
    def transformEndTime: Option[Timestamp]
    def labelingJobArn: Option[LabelingJobArn]
    def autoMLJobArn: Option[AutoMLJobArn]
    def dataProcessing: Option[zio.aws.sagemaker.model.DataProcessing.ReadOnly]
    def experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getTransformJobName: ZIO[Any, AwsError, TransformJobName] =
      AwsError.unwrapOptionField("transformJobName", transformJobName)
    def getTransformJobArn: ZIO[Any, AwsError, TransformJobArn] =
      AwsError.unwrapOptionField("transformJobArn", transformJobArn)
    def getTransformJobStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformJobStatus] =
      AwsError.unwrapOptionField("transformJobStatus", transformJobStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getModelName: ZIO[Any, AwsError, ModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getMaxConcurrentTransforms
        : ZIO[Any, AwsError, MaxConcurrentTransforms] = AwsError
      .unwrapOptionField("maxConcurrentTransforms", maxConcurrentTransforms)
    def getModelClientConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelClientConfig.ReadOnly
    ] = AwsError.unwrapOptionField("modelClientConfig", modelClientConfig)
    def getMaxPayloadInMB: ZIO[Any, AwsError, MaxPayloadInMB] =
      AwsError.unwrapOptionField("maxPayloadInMB", maxPayloadInMB)
    def getBatchStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.BatchStrategy] =
      AwsError.unwrapOptionField("batchStrategy", batchStrategy)
    def getEnvironment: ZIO[Any, AwsError, Map[
      TransformEnvironmentKey,
      TransformEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getTransformInput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformInput.ReadOnly] =
      AwsError.unwrapOptionField("transformInput", transformInput)
    def getTransformOutput
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformOutput.ReadOnly] =
      AwsError.unwrapOptionField("transformOutput", transformOutput)
    def getTransformResources: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TransformResources.ReadOnly
    ] = AwsError.unwrapOptionField("transformResources", transformResources)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTransformStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transformStartTime", transformStartTime)
    def getTransformEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transformEndTime", transformEndTime)
    def getLabelingJobArn: ZIO[Any, AwsError, LabelingJobArn] =
      AwsError.unwrapOptionField("labelingJobArn", labelingJobArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getDataProcessing
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DataProcessing.ReadOnly] =
      AwsError.unwrapOptionField("dataProcessing", dataProcessing)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJob
  ) extends zio.aws.sagemaker.model.TransformJob.ReadOnly {
    override val transformJobName: Option[TransformJobName] = scala
      .Option(impl.transformJobName())
      .map(value => zio.aws.sagemaker.model.primitives.TransformJobName(value))
    override val transformJobArn: Option[TransformJobArn] = scala
      .Option(impl.transformJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.TransformJobArn(value))
    override val transformJobStatus
        : Option[zio.aws.sagemaker.model.TransformJobStatus] = scala
      .Option(impl.transformJobStatus())
      .map(value => zio.aws.sagemaker.model.TransformJobStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val modelName: Option[ModelName] = scala
      .Option(impl.modelName())
      .map(value => zio.aws.sagemaker.model.primitives.ModelName(value))
    override val maxConcurrentTransforms: Option[MaxConcurrentTransforms] =
      scala
        .Option(impl.maxConcurrentTransforms())
        .map(value =>
          zio.aws.sagemaker.model.primitives.MaxConcurrentTransforms(value)
        )
    override val modelClientConfig
        : Option[zio.aws.sagemaker.model.ModelClientConfig.ReadOnly] = scala
      .Option(impl.modelClientConfig())
      .map(value => zio.aws.sagemaker.model.ModelClientConfig.wrap(value))
    override val maxPayloadInMB: Option[MaxPayloadInMB] = scala
      .Option(impl.maxPayloadInMB())
      .map(value => zio.aws.sagemaker.model.primitives.MaxPayloadInMB(value))
    override val batchStrategy: Option[zio.aws.sagemaker.model.BatchStrategy] =
      scala
        .Option(impl.batchStrategy())
        .map(value => zio.aws.sagemaker.model.BatchStrategy.wrap(value))
    override val environment
        : Option[Map[TransformEnvironmentKey, TransformEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TransformEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TransformEnvironmentValue(value)
            })
            .toMap
        )
    override val transformInput
        : Option[zio.aws.sagemaker.model.TransformInput.ReadOnly] = scala
      .Option(impl.transformInput())
      .map(value => zio.aws.sagemaker.model.TransformInput.wrap(value))
    override val transformOutput
        : Option[zio.aws.sagemaker.model.TransformOutput.ReadOnly] = scala
      .Option(impl.transformOutput())
      .map(value => zio.aws.sagemaker.model.TransformOutput.wrap(value))
    override val transformResources
        : Option[zio.aws.sagemaker.model.TransformResources.ReadOnly] = scala
      .Option(impl.transformResources())
      .map(value => zio.aws.sagemaker.model.TransformResources.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val transformStartTime: Option[Timestamp] = scala
      .Option(impl.transformStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val transformEndTime: Option[Timestamp] = scala
      .Option(impl.transformEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val labelingJobArn: Option[LabelingJobArn] = scala
      .Option(impl.labelingJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.LabelingJobArn(value))
    override val autoMLJobArn: Option[AutoMLJobArn] = scala
      .Option(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val dataProcessing
        : Option[zio.aws.sagemaker.model.DataProcessing.ReadOnly] = scala
      .Option(impl.dataProcessing())
      .map(value => zio.aws.sagemaker.model.DataProcessing.wrap(value))
    override val experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] = scala
      .Option(impl.experimentConfig())
      .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJob
  ): zio.aws.sagemaker.model.TransformJob.ReadOnly = new Wrapper(impl)
}
