package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ArnOrName, Url}
import scala.jdk.CollectionConverters.*
final case class SourceAlgorithm(
    modelDataUrl: Option[Url] = None,
    algorithmName: ArnOrName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm = {
    import SourceAlgorithm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm
      .builder()
      .optionallyWith(
        modelDataUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.modelDataUrl)
      .algorithmName(ArnOrName.unwrap(algorithmName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly =
    zio.aws.sagemaker.model.SourceAlgorithm.wrap(buildAwsValue())
}
object SourceAlgorithm {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.SourceAlgorithm =
      zio.aws.sagemaker.model
        .SourceAlgorithm(modelDataUrl.map(value => value), algorithmName)
    def modelDataUrl: Option[Url]
    def algorithmName: ArnOrName
    def getModelDataUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("modelDataUrl", modelDataUrl)
    def getAlgorithmName: ZIO[Any, Nothing, ArnOrName] =
      ZIO.succeed(algorithmName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm
  ) extends zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly {
    override val modelDataUrl: Option[Url] = scala
      .Option(impl.modelDataUrl())
      .map(value => zio.aws.sagemaker.model.primitives.Url(value))
    override val algorithmName: ArnOrName =
      zio.aws.sagemaker.model.primitives.ArnOrName(impl.algorithmName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm
  ): zio.aws.sagemaker.model.SourceAlgorithm.ReadOnly = new Wrapper(impl)
}
