package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class RegisterDevicesRequest(
    deviceFleetName: EntityName,
    devices: Iterable[zio.aws.sagemaker.model.Device],
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest = {
    import RegisterDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest
      .builder()
      .deviceFleetName(EntityName.unwrap(deviceFleetName): java.lang.String)
      .devices(devices.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RegisterDevicesRequest.ReadOnly =
    zio.aws.sagemaker.model.RegisterDevicesRequest.wrap(buildAwsValue())
}
object RegisterDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RegisterDevicesRequest =
      zio.aws.sagemaker.model.RegisterDevicesRequest(
        deviceFleetName,
        devices.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deviceFleetName: EntityName
    def devices: List[zio.aws.sagemaker.model.Device.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getDeviceFleetName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(deviceFleetName)
    def getDevices
        : ZIO[Any, Nothing, List[zio.aws.sagemaker.model.Device.ReadOnly]] =
      ZIO.succeed(devices)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest
  ) extends zio.aws.sagemaker.model.RegisterDevicesRequest.ReadOnly {
    override val deviceFleetName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.deviceFleetName())
    override val devices: List[zio.aws.sagemaker.model.Device.ReadOnly] = impl
      .devices()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.Device.wrap(item)
      }
      .toList
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest
  ): zio.aws.sagemaker.model.RegisterDevicesRequest.ReadOnly = new Wrapper(impl)
}
