package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class RecommendationJobStoppingConditions(
    maxInvocations: Option[Integer] = None,
    modelLatencyThresholds: Option[
      Iterable[zio.aws.sagemaker.model.ModelLatencyThreshold]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions = {
    import RecommendationJobStoppingConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
      .builder()
      .optionallyWith(maxInvocations.map(value => value: java.lang.Integer))(
        _.maxInvocations
      )
      .optionallyWith(
        modelLatencyThresholds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.modelLatencyThresholds)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobStoppingConditions
      .wrap(buildAwsValue())
}
object RecommendationJobStoppingConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.RecommendationJobStoppingConditions =
      zio.aws.sagemaker.model.RecommendationJobStoppingConditions(
        maxInvocations.map(value => value),
        modelLatencyThresholds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxInvocations: Option[Integer]
    def modelLatencyThresholds
        : Option[List[zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly]]
    def getMaxInvocations: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxInvocations", maxInvocations)
    def getModelLatencyThresholds: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "modelLatencyThresholds",
      modelLatencyThresholds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ) extends zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly {
    override val maxInvocations: Option[Integer] =
      scala.Option(impl.maxInvocations()).map(value => value: Integer)
    override val modelLatencyThresholds
        : Option[List[zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly]] =
      scala
        .Option(impl.modelLatencyThresholds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.ModelLatencyThreshold.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions
  ): zio.aws.sagemaker.model.RecommendationJobStoppingConditions.ReadOnly =
    new Wrapper(impl)
}
