package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PipelineExecutionStepMetadata(
    trainingJob: Option[zio.aws.sagemaker.model.TrainingJobStepMetadata] = None,
    processingJob: Option[zio.aws.sagemaker.model.ProcessingJobStepMetadata] =
      None,
    transformJob: Option[zio.aws.sagemaker.model.TransformJobStepMetadata] =
      None,
    tuningJob: Option[zio.aws.sagemaker.model.TuningJobStepMetaData] = None,
    model: Option[zio.aws.sagemaker.model.ModelStepMetadata] = None,
    registerModel: Option[zio.aws.sagemaker.model.RegisterModelStepMetadata] =
      None,
    condition: Option[zio.aws.sagemaker.model.ConditionStepMetadata] = None,
    callback: Option[zio.aws.sagemaker.model.CallbackStepMetadata] = None,
    lambda: Option[zio.aws.sagemaker.model.LambdaStepMetadata] = None,
    qualityCheck: Option[zio.aws.sagemaker.model.QualityCheckStepMetadata] =
      None,
    clarifyCheck: Option[zio.aws.sagemaker.model.ClarifyCheckStepMetadata] =
      None,
    emr: Option[zio.aws.sagemaker.model.EMRStepMetadata] = None,
    fail: Option[zio.aws.sagemaker.model.FailStepMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata = {
    import PipelineExecutionStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata
      .builder()
      .optionallyWith(trainingJob.map(value => value.buildAwsValue()))(
        _.trainingJob
      )
      .optionallyWith(processingJob.map(value => value.buildAwsValue()))(
        _.processingJob
      )
      .optionallyWith(transformJob.map(value => value.buildAwsValue()))(
        _.transformJob
      )
      .optionallyWith(tuningJob.map(value => value.buildAwsValue()))(
        _.tuningJob
      )
      .optionallyWith(model.map(value => value.buildAwsValue()))(_.model)
      .optionallyWith(registerModel.map(value => value.buildAwsValue()))(
        _.registerModel
      )
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(callback.map(value => value.buildAwsValue()))(_.callback)
      .optionallyWith(lambda.map(value => value.buildAwsValue()))(_.lambda)
      .optionallyWith(qualityCheck.map(value => value.buildAwsValue()))(
        _.qualityCheck
      )
      .optionallyWith(clarifyCheck.map(value => value.buildAwsValue()))(
        _.clarifyCheck
      )
      .optionallyWith(emr.map(value => value.buildAwsValue()))(_.emr)
      .optionallyWith(fail.map(value => value.buildAwsValue()))(_.fail)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.PipelineExecutionStepMetadata.wrap(buildAwsValue())
}
object PipelineExecutionStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PipelineExecutionStepMetadata =
      zio.aws.sagemaker.model.PipelineExecutionStepMetadata(
        trainingJob.map(value => value.asEditable),
        processingJob.map(value => value.asEditable),
        transformJob.map(value => value.asEditable),
        tuningJob.map(value => value.asEditable),
        model.map(value => value.asEditable),
        registerModel.map(value => value.asEditable),
        condition.map(value => value.asEditable),
        callback.map(value => value.asEditable),
        lambda.map(value => value.asEditable),
        qualityCheck.map(value => value.asEditable),
        clarifyCheck.map(value => value.asEditable),
        emr.map(value => value.asEditable),
        fail.map(value => value.asEditable)
      )
    def trainingJob
        : Option[zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly]
    def processingJob
        : Option[zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly]
    def transformJob
        : Option[zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly]
    def tuningJob
        : Option[zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly]
    def model: Option[zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly]
    def registerModel
        : Option[zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly]
    def condition
        : Option[zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly]
    def callback: Option[zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly]
    def lambda: Option[zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly]
    def qualityCheck
        : Option[zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly]
    def clarifyCheck
        : Option[zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly]
    def emr: Option[zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly]
    def fail: Option[zio.aws.sagemaker.model.FailStepMetadata.ReadOnly]
    def getTrainingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("trainingJob", trainingJob)
    def getProcessingJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("processingJob", processingJob)
    def getTransformJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("transformJob", transformJob)
    def getTuningJob: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly
    ] = AwsError.unwrapOptionField("tuningJob", tuningJob)
    def getModel: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("model", model)
    def getRegisterModel: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("registerModel", registerModel)
    def getCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("condition", condition)
    def getCallback: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("callback", callback)
    def getLambda: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("lambda", lambda)
    def getQualityCheck: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("qualityCheck", qualityCheck)
    def getClarifyCheck: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("clarifyCheck", clarifyCheck)
    def getEmr
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly] =
      AwsError.unwrapOptionField("emr", emr)
    def getFail: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FailStepMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("fail", fail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata
  ) extends zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly {
    override val trainingJob
        : Option[zio.aws.sagemaker.model.TrainingJobStepMetadata.ReadOnly] =
      scala
        .Option(impl.trainingJob())
        .map(value =>
          zio.aws.sagemaker.model.TrainingJobStepMetadata.wrap(value)
        )
    override val processingJob
        : Option[zio.aws.sagemaker.model.ProcessingJobStepMetadata.ReadOnly] =
      scala
        .Option(impl.processingJob())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingJobStepMetadata.wrap(value)
        )
    override val transformJob
        : Option[zio.aws.sagemaker.model.TransformJobStepMetadata.ReadOnly] =
      scala
        .Option(impl.transformJob())
        .map(value =>
          zio.aws.sagemaker.model.TransformJobStepMetadata.wrap(value)
        )
    override val tuningJob
        : Option[zio.aws.sagemaker.model.TuningJobStepMetaData.ReadOnly] = scala
      .Option(impl.tuningJob())
      .map(value => zio.aws.sagemaker.model.TuningJobStepMetaData.wrap(value))
    override val model
        : Option[zio.aws.sagemaker.model.ModelStepMetadata.ReadOnly] = scala
      .Option(impl.model())
      .map(value => zio.aws.sagemaker.model.ModelStepMetadata.wrap(value))
    override val registerModel
        : Option[zio.aws.sagemaker.model.RegisterModelStepMetadata.ReadOnly] =
      scala
        .Option(impl.registerModel())
        .map(value =>
          zio.aws.sagemaker.model.RegisterModelStepMetadata.wrap(value)
        )
    override val condition
        : Option[zio.aws.sagemaker.model.ConditionStepMetadata.ReadOnly] = scala
      .Option(impl.condition())
      .map(value => zio.aws.sagemaker.model.ConditionStepMetadata.wrap(value))
    override val callback
        : Option[zio.aws.sagemaker.model.CallbackStepMetadata.ReadOnly] = scala
      .Option(impl.callback())
      .map(value => zio.aws.sagemaker.model.CallbackStepMetadata.wrap(value))
    override val lambda
        : Option[zio.aws.sagemaker.model.LambdaStepMetadata.ReadOnly] = scala
      .Option(impl.lambda())
      .map(value => zio.aws.sagemaker.model.LambdaStepMetadata.wrap(value))
    override val qualityCheck
        : Option[zio.aws.sagemaker.model.QualityCheckStepMetadata.ReadOnly] =
      scala
        .Option(impl.qualityCheck())
        .map(value =>
          zio.aws.sagemaker.model.QualityCheckStepMetadata.wrap(value)
        )
    override val clarifyCheck
        : Option[zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly] =
      scala
        .Option(impl.clarifyCheck())
        .map(value =>
          zio.aws.sagemaker.model.ClarifyCheckStepMetadata.wrap(value)
        )
    override val emr: Option[zio.aws.sagemaker.model.EMRStepMetadata.ReadOnly] =
      scala
        .Option(impl.emr())
        .map(value => zio.aws.sagemaker.model.EMRStepMetadata.wrap(value))
    override val fail
        : Option[zio.aws.sagemaker.model.FailStepMetadata.ReadOnly] = scala
      .Option(impl.fail())
      .map(value => zio.aws.sagemaker.model.FailStepMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStepMetadata
  ): zio.aws.sagemaker.model.PipelineExecutionStepMetadata.ReadOnly =
    new Wrapper(impl)
}
