package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ParameterRanges(
    integerParameterRanges: Option[
      Iterable[zio.aws.sagemaker.model.IntegerParameterRange]
    ] = None,
    continuousParameterRanges: Option[
      Iterable[zio.aws.sagemaker.model.ContinuousParameterRange]
    ] = None,
    categoricalParameterRanges: Option[
      Iterable[zio.aws.sagemaker.model.CategoricalParameterRange]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ParameterRanges = {
    import ParameterRanges.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ParameterRanges
      .builder()
      .optionallyWith(
        integerParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.integerParameterRanges)
      .optionallyWith(
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.continuousParameterRanges)
      .optionallyWith(
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.categoricalParameterRanges)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ParameterRanges.ReadOnly =
    zio.aws.sagemaker.model.ParameterRanges.wrap(buildAwsValue())
}
object ParameterRanges {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ParameterRanges =
      zio.aws.sagemaker.model.ParameterRanges(
        integerParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        continuousParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        categoricalParameterRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def integerParameterRanges
        : Option[List[zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly]]
    def continuousParameterRanges: Option[
      List[zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly]
    ]
    def categoricalParameterRanges: Option[
      List[zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly]
    ]
    def getIntegerParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "integerParameterRanges",
      integerParameterRanges
    )
    def getContinuousParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "continuousParameterRanges",
      continuousParameterRanges
    )
    def getCategoricalParameterRanges: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "categoricalParameterRanges",
      categoricalParameterRanges
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ) extends zio.aws.sagemaker.model.ParameterRanges.ReadOnly {
    override val integerParameterRanges
        : Option[List[zio.aws.sagemaker.model.IntegerParameterRange.ReadOnly]] =
      scala
        .Option(impl.integerParameterRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.IntegerParameterRange.wrap(item)
          }.toList
        )
    override val continuousParameterRanges: Option[
      List[zio.aws.sagemaker.model.ContinuousParameterRange.ReadOnly]
    ] = scala
      .Option(impl.continuousParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ContinuousParameterRange.wrap(item)
        }.toList
      )
    override val categoricalParameterRanges: Option[
      List[zio.aws.sagemaker.model.CategoricalParameterRange.ReadOnly]
    ] = scala
      .Option(impl.categoricalParameterRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.CategoricalParameterRange.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ParameterRanges
  ): zio.aws.sagemaker.model.ParameterRanges.ReadOnly = new Wrapper(impl)
}
