package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OfflineStoreConfig(
    s3StorageConfig: zio.aws.sagemaker.model.S3StorageConfig,
    disableGlueTableCreation: Option[Boolean] = None,
    dataCatalogConfig: Option[zio.aws.sagemaker.model.DataCatalogConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig = {
    import OfflineStoreConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig
      .builder()
      .s3StorageConfig(s3StorageConfig.buildAwsValue())
      .optionallyWith(
        disableGlueTableCreation.map(value => value: java.lang.Boolean)
      )(_.disableGlueTableCreation)
      .optionallyWith(dataCatalogConfig.map(value => value.buildAwsValue()))(
        _.dataCatalogConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly =
    zio.aws.sagemaker.model.OfflineStoreConfig.wrap(buildAwsValue())
}
object OfflineStoreConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.OfflineStoreConfig =
      zio.aws.sagemaker.model.OfflineStoreConfig(
        s3StorageConfig.asEditable,
        disableGlueTableCreation.map(value => value),
        dataCatalogConfig.map(value => value.asEditable)
      )
    def s3StorageConfig: zio.aws.sagemaker.model.S3StorageConfig.ReadOnly
    def disableGlueTableCreation: Option[Boolean]
    def dataCatalogConfig
        : Option[zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly]
    def getS3StorageConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.S3StorageConfig.ReadOnly] =
      ZIO.succeed(s3StorageConfig)
    def getDisableGlueTableCreation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("disableGlueTableCreation", disableGlueTableCreation)
    def getDataCatalogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataCatalogConfig", dataCatalogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig
  ) extends zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly {
    override val s3StorageConfig
        : zio.aws.sagemaker.model.S3StorageConfig.ReadOnly =
      zio.aws.sagemaker.model.S3StorageConfig.wrap(impl.s3StorageConfig())
    override val disableGlueTableCreation: Option[Boolean] =
      scala.Option(impl.disableGlueTableCreation()).map(value => value: Boolean)
    override val dataCatalogConfig
        : Option[zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly] = scala
      .Option(impl.dataCatalogConfig())
      .map(value => zio.aws.sagemaker.model.DataCatalogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.OfflineStoreConfig
  ): zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly = new Wrapper(impl)
}
