package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{Integer, String64}
import scala.jdk.CollectionConverters.*
final case class ModelLatencyThreshold(
    percentile: Option[String64] = None,
    valueInMilliseconds: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold = {
    import ModelLatencyThreshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold
      .builder()
      .optionallyWith(
        percentile.map(value => String64.unwrap(value): java.lang.String)
      )(_.percentile)
      .optionallyWith(
        valueInMilliseconds.map(value => value: java.lang.Integer)
      )(_.valueInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly =
    zio.aws.sagemaker.model.ModelLatencyThreshold.wrap(buildAwsValue())
}
object ModelLatencyThreshold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelLatencyThreshold =
      zio.aws.sagemaker.model.ModelLatencyThreshold(
        percentile.map(value => value),
        valueInMilliseconds.map(value => value)
      )
    def percentile: Option[String64]
    def valueInMilliseconds: Option[Integer]
    def getPercentile: ZIO[Any, AwsError, String64] =
      AwsError.unwrapOptionField("percentile", percentile)
    def getValueInMilliseconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("valueInMilliseconds", valueInMilliseconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold
  ) extends zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly {
    override val percentile: Option[String64] = scala
      .Option(impl.percentile())
      .map(value => zio.aws.sagemaker.model.primitives.String64(value))
    override val valueInMilliseconds: Option[Integer] =
      scala.Option(impl.valueInMilliseconds()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelLatencyThreshold
  ): zio.aws.sagemaker.model.ModelLatencyThreshold.ReadOnly = new Wrapper(impl)
}
