package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListTransformJobsResponse(
    transformJobSummaries: Iterable[
      zio.aws.sagemaker.model.TransformJobSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse = {
    import ListTransformJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse
      .builder()
      .transformJobSummaries(transformJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListTransformJobsResponse.wrap(buildAwsValue())
}
object ListTransformJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListTransformJobsResponse =
      zio.aws.sagemaker.model.ListTransformJobsResponse(
        transformJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def transformJobSummaries
        : List[zio.aws.sagemaker.model.TransformJobSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getTransformJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.TransformJobSummary.ReadOnly
    ]] = ZIO.succeed(transformJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse
  ) extends zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly {
    override val transformJobSummaries
        : List[zio.aws.sagemaker.model.TransformJobSummary.ReadOnly] = impl
      .transformJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.TransformJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse
  ): zio.aws.sagemaker.model.ListTransformJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
