package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListProjectsResponse(
    projectSummaryList: Iterable[zio.aws.sagemaker.model.ProjectSummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse
      .builder()
      .projectSummaryList(projectSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListProjectsResponse =
      zio.aws.sagemaker.model.ListProjectsResponse(
        projectSummaryList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def projectSummaryList
        : List[zio.aws.sagemaker.model.ProjectSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getProjectSummaryList: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProjectSummary.ReadOnly
    ]] = ZIO.succeed(projectSummaryList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse
  ) extends zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly {
    override val projectSummaryList
        : List[zio.aws.sagemaker.model.ProjectSummary.ReadOnly] = impl
      .projectSummaryList()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProjectSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse
  ): zio.aws.sagemaker.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
