package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListMonitoringExecutionsResponse(
    monitoringExecutionSummaries: Iterable[
      zio.aws.sagemaker.model.MonitoringExecutionSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse = {
    import ListMonitoringExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse
      .builder()
      .monitoringExecutionSummaries(monitoringExecutionSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListMonitoringExecutionsResponse
      .wrap(buildAwsValue())
}
object ListMonitoringExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListMonitoringExecutionsResponse =
      zio.aws.sagemaker.model.ListMonitoringExecutionsResponse(
        monitoringExecutionSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def monitoringExecutionSummaries
        : List[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getMonitoringExecutionSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly
    ]] = ZIO.succeed(monitoringExecutionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse
  ) extends zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly {
    override val monitoringExecutionSummaries
        : List[zio.aws.sagemaker.model.MonitoringExecutionSummary.ReadOnly] =
      impl
        .monitoringExecutionSummaries()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.MonitoringExecutionSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse
  ): zio.aws.sagemaker.model.ListMonitoringExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
