package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListInferenceRecommendationsJobsResponse(
    inferenceRecommendationsJobs: Iterable[
      zio.aws.sagemaker.model.InferenceRecommendationsJob
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse = {
    import ListInferenceRecommendationsJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse
      .builder()
      .inferenceRecommendationsJobs(inferenceRecommendationsJobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse
      .wrap(buildAwsValue())
}
object ListInferenceRecommendationsJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse =
      zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse(
        inferenceRecommendationsJobs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def inferenceRecommendationsJobs
        : List[zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly]
    def nextToken: Option[NextToken]
    def getInferenceRecommendationsJobs: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly
    ]] = ZIO.succeed(inferenceRecommendationsJobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse
  ) extends zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly {
    override val inferenceRecommendationsJobs
        : List[zio.aws.sagemaker.model.InferenceRecommendationsJob.ReadOnly] =
      impl
        .inferenceRecommendationsJobs()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.InferenceRecommendationsJob.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse
  ): zio.aws.sagemaker.model.ListInferenceRecommendationsJobsResponse.ReadOnly =
    new Wrapper(impl)
}
