package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListEdgePackagingJobsResponse(
    edgePackagingJobSummaries: Iterable[
      zio.aws.sagemaker.model.EdgePackagingJobSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse = {
    import ListEdgePackagingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse
      .builder()
      .edgePackagingJobSummaries(edgePackagingJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.wrap(buildAwsValue())
}
object ListEdgePackagingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListEdgePackagingJobsResponse =
      zio.aws.sagemaker.model.ListEdgePackagingJobsResponse(
        edgePackagingJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def edgePackagingJobSummaries
        : List[zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getEdgePackagingJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly
    ]] = ZIO.succeed(edgePackagingJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse
  ) extends zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly {
    override val edgePackagingJobSummaries
        : List[zio.aws.sagemaker.model.EdgePackagingJobSummary.ReadOnly] = impl
      .edgePackagingJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.EdgePackagingJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse
  ): zio.aws.sagemaker.model.ListEdgePackagingJobsResponse.ReadOnly =
    new Wrapper(impl)
}
