package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListActionsResponse(
    actionSummaries: Option[Iterable[zio.aws.sagemaker.model.ActionSummary]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListActionsResponse = {
    import ListActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListActionsResponse
      .builder()
      .optionallyWith(
        actionSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListActionsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListActionsResponse.wrap(buildAwsValue())
}
object ListActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListActionsResponse =
      zio.aws.sagemaker.model.ListActionsResponse(
        actionSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def actionSummaries
        : Option[List[zio.aws.sagemaker.model.ActionSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getActionSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ActionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("actionSummaries", actionSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListActionsResponse
  ) extends zio.aws.sagemaker.model.ListActionsResponse.ReadOnly {
    override val actionSummaries
        : Option[List[zio.aws.sagemaker.model.ActionSummary.ReadOnly]] = scala
      .Option(impl.actionSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ActionSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListActionsResponse
  ): zio.aws.sagemaker.model.ListActionsResponse.ReadOnly = new Wrapper(impl)
}
