package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSearchSuggestionsResponse(
    propertyNameSuggestions: Option[
      Iterable[zio.aws.sagemaker.model.PropertyNameSuggestion]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse = {
    import GetSearchSuggestionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse
      .builder()
      .optionallyWith(
        propertyNameSuggestions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyNameSuggestions)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly =
    zio.aws.sagemaker.model.GetSearchSuggestionsResponse.wrap(buildAwsValue())
}
object GetSearchSuggestionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GetSearchSuggestionsResponse =
      zio.aws.sagemaker.model.GetSearchSuggestionsResponse(
        propertyNameSuggestions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def propertyNameSuggestions
        : Option[List[zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly]]
    def getPropertyNameSuggestions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "propertyNameSuggestions",
      propertyNameSuggestions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse
  ) extends zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly {
    override val propertyNameSuggestions: Option[
      List[zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly]
    ] = scala
      .Option(impl.propertyNameSuggestions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.PropertyNameSuggestion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse
  ): zio.aws.sagemaker.model.GetSearchSuggestionsResponse.ReadOnly =
    new Wrapper(impl)
}
