package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  RoleArn,
  FeatureGroupArn,
  FailureReason,
  FeatureGroupName,
  Description,
  FeatureName
}
import scala.jdk.CollectionConverters.*
final case class FeatureGroup(
    featureGroupArn: Option[FeatureGroupArn] = None,
    featureGroupName: Option[FeatureGroupName] = None,
    recordIdentifierFeatureName: Option[FeatureName] = None,
    eventTimeFeatureName: Option[FeatureName] = None,
    featureDefinitions: Option[
      Iterable[zio.aws.sagemaker.model.FeatureDefinition]
    ] = None,
    creationTime: Option[CreationTime] = None,
    onlineStoreConfig: Option[zio.aws.sagemaker.model.OnlineStoreConfig] = None,
    offlineStoreConfig: Option[zio.aws.sagemaker.model.OfflineStoreConfig] =
      None,
    roleArn: Option[RoleArn] = None,
    featureGroupStatus: Option[zio.aws.sagemaker.model.FeatureGroupStatus] =
      None,
    offlineStoreStatus: Option[zio.aws.sagemaker.model.OfflineStoreStatus] =
      None,
    failureReason: Option[FailureReason] = None,
    description: Option[Description] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.FeatureGroup = {
    import FeatureGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.FeatureGroup
      .builder()
      .optionallyWith(
        featureGroupArn.map(value =>
          FeatureGroupArn.unwrap(value): java.lang.String
        )
      )(_.featureGroupArn)
      .optionallyWith(
        featureGroupName.map(value =>
          FeatureGroupName.unwrap(value): java.lang.String
        )
      )(_.featureGroupName)
      .optionallyWith(
        recordIdentifierFeatureName.map(value =>
          FeatureName.unwrap(value): java.lang.String
        )
      )(_.recordIdentifierFeatureName)
      .optionallyWith(
        eventTimeFeatureName.map(value =>
          FeatureName.unwrap(value): java.lang.String
        )
      )(_.eventTimeFeatureName)
      .optionallyWith(
        featureDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.featureDefinitions)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(onlineStoreConfig.map(value => value.buildAwsValue()))(
        _.onlineStoreConfig
      )
      .optionallyWith(offlineStoreConfig.map(value => value.buildAwsValue()))(
        _.offlineStoreConfig
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(featureGroupStatus.map(value => value.unwrap))(
        _.featureGroupStatus
      )
      .optionallyWith(offlineStoreStatus.map(value => value.buildAwsValue()))(
        _.offlineStoreStatus
      )
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.FeatureGroup.ReadOnly =
    zio.aws.sagemaker.model.FeatureGroup.wrap(buildAwsValue())
}
object FeatureGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.FeatureGroup =
      zio.aws.sagemaker.model.FeatureGroup(
        featureGroupArn.map(value => value),
        featureGroupName.map(value => value),
        recordIdentifierFeatureName.map(value => value),
        eventTimeFeatureName.map(value => value),
        featureDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        onlineStoreConfig.map(value => value.asEditable),
        offlineStoreConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        featureGroupStatus.map(value => value),
        offlineStoreStatus.map(value => value.asEditable),
        failureReason.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def featureGroupArn: Option[FeatureGroupArn]
    def featureGroupName: Option[FeatureGroupName]
    def recordIdentifierFeatureName: Option[FeatureName]
    def eventTimeFeatureName: Option[FeatureName]
    def featureDefinitions
        : Option[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]]
    def creationTime: Option[CreationTime]
    def onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly]
    def offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly]
    def roleArn: Option[RoleArn]
    def featureGroupStatus: Option[zio.aws.sagemaker.model.FeatureGroupStatus]
    def offlineStoreStatus
        : Option[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly]
    def failureReason: Option[FailureReason]
    def description: Option[Description]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getFeatureGroupArn: ZIO[Any, AwsError, FeatureGroupArn] =
      AwsError.unwrapOptionField("featureGroupArn", featureGroupArn)
    def getFeatureGroupName: ZIO[Any, AwsError, FeatureGroupName] =
      AwsError.unwrapOptionField("featureGroupName", featureGroupName)
    def getRecordIdentifierFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField(
        "recordIdentifierFeatureName",
        recordIdentifierFeatureName
      )
    def getEventTimeFeatureName: ZIO[Any, AwsError, FeatureName] =
      AwsError.unwrapOptionField("eventTimeFeatureName", eventTimeFeatureName)
    def getFeatureDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.FeatureDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("featureDefinitions", featureDefinitions)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getOnlineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("onlineStoreConfig", onlineStoreConfig)
    def getOfflineStoreConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreConfig", offlineStoreConfig)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getFeatureGroupStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.FeatureGroupStatus] =
      AwsError.unwrapOptionField("featureGroupStatus", featureGroupStatus)
    def getOfflineStoreStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly
    ] = AwsError.unwrapOptionField("offlineStoreStatus", offlineStoreStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ) extends zio.aws.sagemaker.model.FeatureGroup.ReadOnly {
    override val featureGroupArn: Option[FeatureGroupArn] = scala
      .Option(impl.featureGroupArn())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureGroupArn(value))
    override val featureGroupName: Option[FeatureGroupName] = scala
      .Option(impl.featureGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureGroupName(value))
    override val recordIdentifierFeatureName: Option[FeatureName] = scala
      .Option(impl.recordIdentifierFeatureName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val eventTimeFeatureName: Option[FeatureName] = scala
      .Option(impl.eventTimeFeatureName())
      .map(value => zio.aws.sagemaker.model.primitives.FeatureName(value))
    override val featureDefinitions
        : Option[List[zio.aws.sagemaker.model.FeatureDefinition.ReadOnly]] =
      scala
        .Option(impl.featureDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.FeatureDefinition.wrap(item)
          }.toList
        )
    override val creationTime: Option[CreationTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val onlineStoreConfig
        : Option[zio.aws.sagemaker.model.OnlineStoreConfig.ReadOnly] = scala
      .Option(impl.onlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OnlineStoreConfig.wrap(value))
    override val offlineStoreConfig
        : Option[zio.aws.sagemaker.model.OfflineStoreConfig.ReadOnly] = scala
      .Option(impl.offlineStoreConfig())
      .map(value => zio.aws.sagemaker.model.OfflineStoreConfig.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val featureGroupStatus
        : Option[zio.aws.sagemaker.model.FeatureGroupStatus] = scala
      .Option(impl.featureGroupStatus())
      .map(value => zio.aws.sagemaker.model.FeatureGroupStatus.wrap(value))
    override val offlineStoreStatus
        : Option[zio.aws.sagemaker.model.OfflineStoreStatus.ReadOnly] = scala
      .Option(impl.offlineStoreStatus())
      .map(value => zio.aws.sagemaker.model.OfflineStoreStatus.wrap(value))
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.sagemaker.model.primitives.Description(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.FeatureGroup
  ): zio.aws.sagemaker.model.FeatureGroup.ReadOnly = new Wrapper(impl)
}
