package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.SecurityGroupId
import scala.jdk.CollectionConverters.*
final case class DomainSettings(
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    rStudioServerProDomainSettings: Option[
      zio.aws.sagemaker.model.RStudioServerProDomainSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DomainSettings = {
    import DomainSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DomainSettings
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        rStudioServerProDomainSettings.map(value => value.buildAwsValue())
      )(_.rStudioServerProDomainSettings)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DomainSettings.ReadOnly =
    zio.aws.sagemaker.model.DomainSettings.wrap(buildAwsValue())
}
object DomainSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DomainSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DomainSettings =
      zio.aws.sagemaker.model.DomainSettings(
        securityGroupIds.map(value => value),
        rStudioServerProDomainSettings.map(value => value.asEditable)
      )
    def securityGroupIds: Option[List[SecurityGroupId]]
    def rStudioServerProDomainSettings: Option[
      zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly
    ]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getRStudioServerProDomainSettings: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rStudioServerProDomainSettings",
      rStudioServerProDomainSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettings
  ) extends zio.aws.sagemaker.model.DomainSettings.ReadOnly {
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val rStudioServerProDomainSettings: Option[
      zio.aws.sagemaker.model.RStudioServerProDomainSettings.ReadOnly
    ] = scala
      .Option(impl.rStudioServerProDomainSettings())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProDomainSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DomainSettings
  ): zio.aws.sagemaker.model.DomainSettings.ReadOnly = new Wrapper(impl)
}
