package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  CustomerMetadataValue,
  Timestamp,
  CustomerMetadataKey,
  CertifyForMarketplace,
  ApprovalDescription,
  ModelPackageVersion,
  ModelPackageArn,
  EntityDescription,
  EntityName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeModelPackageResponse(
    modelPackageName: EntityName,
    modelPackageGroupName: Option[EntityName] = None,
    modelPackageVersion: Option[ModelPackageVersion] = None,
    modelPackageArn: ModelPackageArn,
    modelPackageDescription: Option[EntityDescription] = None,
    creationTime: CreationTime,
    inferenceSpecification: Option[
      zio.aws.sagemaker.model.InferenceSpecification
    ] = None,
    sourceAlgorithmSpecification: Option[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification
    ] = None,
    validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification
    ] = None,
    modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus,
    modelPackageStatusDetails: zio.aws.sagemaker.model.ModelPackageStatusDetails,
    certifyForMarketplace: Option[CertifyForMarketplace] = None,
    modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus] =
      None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    modelMetrics: Option[zio.aws.sagemaker.model.ModelMetrics] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    approvalDescription: Option[ApprovalDescription] = None,
    customerMetadataProperties: Option[
      Map[CustomerMetadataKey, CustomerMetadataValue]
    ] = None,
    driftCheckBaselines: Option[zio.aws.sagemaker.model.DriftCheckBaselines] =
      None,
    domain: Option[String] = None,
    task: Option[String] = None,
    samplePayloadUrl: Option[String] = None,
    additionalInferenceSpecifications: Option[Iterable[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse = {
    import DescribeModelPackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
      .builder()
      .modelPackageName(EntityName.unwrap(modelPackageName): java.lang.String)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          EntityName.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        modelPackageVersion.map(value =>
          ModelPackageVersion.unwrap(value): Integer
        )
      )(_.modelPackageVersion)
      .modelPackageArn(
        ModelPackageArn.unwrap(modelPackageArn): java.lang.String
      )
      .optionallyWith(
        modelPackageDescription.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.modelPackageDescription)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .optionallyWith(
        inferenceSpecification.map(value => value.buildAwsValue())
      )(_.inferenceSpecification)
      .optionallyWith(
        sourceAlgorithmSpecification.map(value => value.buildAwsValue())
      )(_.sourceAlgorithmSpecification)
      .optionallyWith(
        validationSpecification.map(value => value.buildAwsValue())
      )(_.validationSpecification)
      .modelPackageStatus(modelPackageStatus.unwrap)
      .modelPackageStatusDetails(modelPackageStatusDetails.buildAwsValue())
      .optionallyWith(
        certifyForMarketplace.map(value =>
          CertifyForMarketplace.unwrap(value): java.lang.Boolean
        )
      )(_.certifyForMarketplace)
      .optionallyWith(modelApprovalStatus.map(value => value.unwrap))(
        _.modelApprovalStatus
      )
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(modelMetrics.map(value => value.buildAwsValue()))(
        _.modelMetrics
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        approvalDescription.map(value =>
          ApprovalDescription.unwrap(value): java.lang.String
        )
      )(_.approvalDescription)
      .optionallyWith(
        customerMetadataProperties.map(value =>
          value
            .map({ case (key, value) =>
              (CustomerMetadataKey.unwrap(
                key
              ): java.lang.String) -> (CustomerMetadataValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.customerMetadataProperties)
      .optionallyWith(driftCheckBaselines.map(value => value.buildAwsValue()))(
        _.driftCheckBaselines
      )
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(samplePayloadUrl.map(value => value: java.lang.String))(
        _.samplePayloadUrl
      )
      .optionallyWith(
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalInferenceSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelPackageResponse.wrap(buildAwsValue())
}
object DescribeModelPackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelPackageResponse =
      zio.aws.sagemaker.model.DescribeModelPackageResponse(
        modelPackageName,
        modelPackageGroupName.map(value => value),
        modelPackageVersion.map(value => value),
        modelPackageArn,
        modelPackageDescription.map(value => value),
        creationTime,
        inferenceSpecification.map(value => value.asEditable),
        sourceAlgorithmSpecification.map(value => value.asEditable),
        validationSpecification.map(value => value.asEditable),
        modelPackageStatus,
        modelPackageStatusDetails.asEditable,
        certifyForMarketplace.map(value => value),
        modelApprovalStatus.map(value => value),
        createdBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        modelMetrics.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        approvalDescription.map(value => value),
        customerMetadataProperties.map(value => value),
        driftCheckBaselines.map(value => value.asEditable),
        domain.map(value => value),
        task.map(value => value),
        samplePayloadUrl.map(value => value),
        additionalInferenceSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def modelPackageName: EntityName
    def modelPackageGroupName: Option[EntityName]
    def modelPackageVersion: Option[ModelPackageVersion]
    def modelPackageArn: ModelPackageArn
    def modelPackageDescription: Option[EntityDescription]
    def creationTime: CreationTime
    def inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly]
    def sourceAlgorithmSpecification
        : Option[zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly]
    def validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ]
    def modelPackageStatus: zio.aws.sagemaker.model.ModelPackageStatus
    def modelPackageStatusDetails
        : zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly
    def certifyForMarketplace: Option[CertifyForMarketplace]
    def modelApprovalStatus: Option[zio.aws.sagemaker.model.ModelApprovalStatus]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def modelMetrics: Option[zio.aws.sagemaker.model.ModelMetrics.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def approvalDescription: Option[ApprovalDescription]
    def customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]]
    def driftCheckBaselines
        : Option[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly]
    def domain: Option[String]
    def task: Option[String]
    def samplePayloadUrl: Option[String]
    def additionalInferenceSpecifications: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]]
    def getModelPackageName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(modelPackageName)
    def getModelPackageGroupName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getModelPackageVersion: ZIO[Any, AwsError, ModelPackageVersion] =
      AwsError.unwrapOptionField("modelPackageVersion", modelPackageVersion)
    def getModelPackageArn: ZIO[Any, Nothing, ModelPackageArn] =
      ZIO.succeed(modelPackageArn)
    def getModelPackageDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField(
        "modelPackageDescription",
        modelPackageDescription
      )
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getInferenceSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.InferenceSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inferenceSpecification",
      inferenceSpecification
    )
    def getSourceAlgorithmSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sourceAlgorithmSpecification",
      sourceAlgorithmSpecification
    )
    def getValidationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validationSpecification",
      validationSpecification
    )
    def getModelPackageStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelPackageStatus] =
      ZIO.succeed(modelPackageStatus)
    def getModelPackageStatusDetails: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly
    ] = ZIO.succeed(modelPackageStatusDetails)
    def getCertifyForMarketplace: ZIO[Any, AwsError, CertifyForMarketplace] =
      AwsError.unwrapOptionField("certifyForMarketplace", certifyForMarketplace)
    def getModelApprovalStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelApprovalStatus] =
      AwsError.unwrapOptionField("modelApprovalStatus", modelApprovalStatus)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getModelMetrics
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelMetrics.ReadOnly] =
      AwsError.unwrapOptionField("modelMetrics", modelMetrics)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getApprovalDescription: ZIO[Any, AwsError, ApprovalDescription] =
      AwsError.unwrapOptionField("approvalDescription", approvalDescription)
    def getCustomerMetadataProperties
        : ZIO[Any, AwsError, Map[CustomerMetadataKey, CustomerMetadataValue]] =
      AwsError.unwrapOptionField(
        "customerMetadataProperties",
        customerMetadataProperties
      )
    def getDriftCheckBaselines: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly
    ] = AwsError.unwrapOptionField("driftCheckBaselines", driftCheckBaselines)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getSamplePayloadUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("samplePayloadUrl", samplePayloadUrl)
    def getAdditionalInferenceSpecifications: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalInferenceSpecifications",
      additionalInferenceSpecifications
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ) extends zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly {
    override val modelPackageName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.modelPackageName())
    override val modelPackageGroupName: Option[EntityName] = scala
      .Option(impl.modelPackageGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.EntityName(value))
    override val modelPackageVersion: Option[ModelPackageVersion] = scala
      .Option(impl.modelPackageVersion())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ModelPackageVersion(value)
      )
    override val modelPackageArn: ModelPackageArn =
      zio.aws.sagemaker.model.primitives.ModelPackageArn(impl.modelPackageArn())
    override val modelPackageDescription: Option[EntityDescription] = scala
      .Option(impl.modelPackageDescription())
      .map(value => zio.aws.sagemaker.model.primitives.EntityDescription(value))
    override val creationTime: CreationTime =
      zio.aws.sagemaker.model.primitives.CreationTime(impl.creationTime())
    override val inferenceSpecification
        : Option[zio.aws.sagemaker.model.InferenceSpecification.ReadOnly] =
      scala
        .Option(impl.inferenceSpecification())
        .map(value =>
          zio.aws.sagemaker.model.InferenceSpecification.wrap(value)
        )
    override val sourceAlgorithmSpecification: Option[
      zio.aws.sagemaker.model.SourceAlgorithmSpecification.ReadOnly
    ] = scala
      .Option(impl.sourceAlgorithmSpecification())
      .map(value =>
        zio.aws.sagemaker.model.SourceAlgorithmSpecification.wrap(value)
      )
    override val validationSpecification: Option[
      zio.aws.sagemaker.model.ModelPackageValidationSpecification.ReadOnly
    ] = scala
      .Option(impl.validationSpecification())
      .map(value =>
        zio.aws.sagemaker.model.ModelPackageValidationSpecification.wrap(value)
      )
    override val modelPackageStatus
        : zio.aws.sagemaker.model.ModelPackageStatus =
      zio.aws.sagemaker.model.ModelPackageStatus.wrap(impl.modelPackageStatus())
    override val modelPackageStatusDetails
        : zio.aws.sagemaker.model.ModelPackageStatusDetails.ReadOnly =
      zio.aws.sagemaker.model.ModelPackageStatusDetails
        .wrap(impl.modelPackageStatusDetails())
    override val certifyForMarketplace: Option[CertifyForMarketplace] = scala
      .Option(impl.certifyForMarketplace())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CertifyForMarketplace(value)
      )
    override val modelApprovalStatus
        : Option[zio.aws.sagemaker.model.ModelApprovalStatus] = scala
      .Option(impl.modelApprovalStatus())
      .map(value => zio.aws.sagemaker.model.ModelApprovalStatus.wrap(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val modelMetrics
        : Option[zio.aws.sagemaker.model.ModelMetrics.ReadOnly] = scala
      .Option(impl.modelMetrics())
      .map(value => zio.aws.sagemaker.model.ModelMetrics.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val approvalDescription: Option[ApprovalDescription] = scala
      .Option(impl.approvalDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ApprovalDescription(value)
      )
    override val customerMetadataProperties
        : Option[Map[CustomerMetadataKey, CustomerMetadataValue]] = scala
      .Option(impl.customerMetadataProperties())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.CustomerMetadataKey(
              key
            ) -> zio.aws.sagemaker.model.primitives.CustomerMetadataValue(value)
          })
          .toMap
      )
    override val driftCheckBaselines
        : Option[zio.aws.sagemaker.model.DriftCheckBaselines.ReadOnly] = scala
      .Option(impl.driftCheckBaselines())
      .map(value => zio.aws.sagemaker.model.DriftCheckBaselines.wrap(value))
    override val domain: Option[String] =
      scala.Option(impl.domain()).map(value => value: String)
    override val task: Option[String] =
      scala.Option(impl.task()).map(value => value: String)
    override val samplePayloadUrl: Option[String] =
      scala.Option(impl.samplePayloadUrl()).map(value => value: String)
    override val additionalInferenceSpecifications: Option[List[
      zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition.ReadOnly
    ]] = scala
      .Option(impl.additionalInferenceSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.AdditionalInferenceSpecificationDefinition
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse
  ): zio.aws.sagemaker.model.DescribeModelPackageResponse.ReadOnly =
    new Wrapper(impl)
}
