package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataSource(
    s3DataSource: Option[zio.aws.sagemaker.model.S3DataSource] = None,
    fileSystemDataSource: Option[zio.aws.sagemaker.model.FileSystemDataSource] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataSource
      .builder()
      .optionallyWith(s3DataSource.map(value => value.buildAwsValue()))(
        _.s3DataSource
      )
      .optionallyWith(fileSystemDataSource.map(value => value.buildAwsValue()))(
        _.fileSystemDataSource
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataSource.ReadOnly =
    zio.aws.sagemaker.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataSource =
      zio.aws.sagemaker.model.DataSource(
        s3DataSource.map(value => value.asEditable),
        fileSystemDataSource.map(value => value.asEditable)
      )
    def s3DataSource: Option[zio.aws.sagemaker.model.S3DataSource.ReadOnly]
    def fileSystemDataSource
        : Option[zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly]
    def getS3DataSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.S3DataSource.ReadOnly] =
      AwsError.unwrapOptionField("s3DataSource", s3DataSource)
    def getFileSystemDataSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly
    ] = AwsError.unwrapOptionField("fileSystemDataSource", fileSystemDataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataSource
  ) extends zio.aws.sagemaker.model.DataSource.ReadOnly {
    override val s3DataSource
        : Option[zio.aws.sagemaker.model.S3DataSource.ReadOnly] = scala
      .Option(impl.s3DataSource())
      .map(value => zio.aws.sagemaker.model.S3DataSource.wrap(value))
    override val fileSystemDataSource
        : Option[zio.aws.sagemaker.model.FileSystemDataSource.ReadOnly] = scala
      .Option(impl.fileSystemDataSource())
      .map(value => zio.aws.sagemaker.model.FileSystemDataSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataSource
  ): zio.aws.sagemaker.model.DataSource.ReadOnly = new Wrapper(impl)
}
