package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ExperimentEntityName
import scala.jdk.CollectionConverters.*
final case class CreateTrialRequest(
    trialName: ExperimentEntityName,
    displayName: Option[ExperimentEntityName] = None,
    experimentName: ExperimentEntityName,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest = {
    import CreateTrialRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest
      .builder()
      .trialName(ExperimentEntityName.unwrap(trialName): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .experimentName(
        ExperimentEntityName.unwrap(experimentName): java.lang.String
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateTrialRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateTrialRequest.wrap(buildAwsValue())
}
object CreateTrialRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateTrialRequest =
      zio.aws.sagemaker.model.CreateTrialRequest(
        trialName,
        displayName.map(value => value),
        experimentName,
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trialName: ExperimentEntityName
    def displayName: Option[ExperimentEntityName]
    def experimentName: ExperimentEntityName
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getTrialName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(trialName)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getExperimentName: ZIO[Any, Nothing, ExperimentEntityName] =
      ZIO.succeed(experimentName)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest
  ) extends zio.aws.sagemaker.model.CreateTrialRequest.ReadOnly {
    override val trialName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives.ExperimentEntityName(impl.trialName())
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val experimentName: ExperimentEntityName =
      zio.aws.sagemaker.model.primitives
        .ExperimentEntityName(impl.experimentName())
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest
  ): zio.aws.sagemaker.model.CreateTrialRequest.ReadOnly = new Wrapper(impl)
}
