package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  ProcessingEnvironmentValue,
  ProcessingEnvironmentKey,
  ProcessingJobName
}
import scala.jdk.CollectionConverters.*
final case class CreateProcessingJobRequest(
    processingInputs: Option[
      Iterable[zio.aws.sagemaker.model.ProcessingInput]
    ] = None,
    processingOutputConfig: Option[
      zio.aws.sagemaker.model.ProcessingOutputConfig
    ] = None,
    processingJobName: ProcessingJobName,
    processingResources: zio.aws.sagemaker.model.ProcessingResources,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.ProcessingStoppingCondition
    ] = None,
    appSpecification: zio.aws.sagemaker.model.AppSpecification,
    environment: Option[
      Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]
    ] = None,
    networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig] = None,
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    experimentConfig: Option[zio.aws.sagemaker.model.ExperimentConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest = {
    import CreateProcessingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest
      .builder()
      .optionallyWith(
        processingInputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processingInputs)
      .optionallyWith(
        processingOutputConfig.map(value => value.buildAwsValue())
      )(_.processingOutputConfig)
      .processingJobName(
        ProcessingJobName.unwrap(processingJobName): java.lang.String
      )
      .processingResources(processingResources.buildAwsValue())
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .appSpecification(appSpecification.buildAwsValue())
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (ProcessingEnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (ProcessingEnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateProcessingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateProcessingJobRequest.wrap(buildAwsValue())
}
object CreateProcessingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateProcessingJobRequest =
      zio.aws.sagemaker.model.CreateProcessingJobRequest(
        processingInputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processingOutputConfig.map(value => value.asEditable),
        processingJobName,
        processingResources.asEditable,
        stoppingCondition.map(value => value.asEditable),
        appSpecification.asEditable,
        environment.map(value => value),
        networkConfig.map(value => value.asEditable),
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        experimentConfig.map(value => value.asEditable)
      )
    def processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]]
    def processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly]
    def processingJobName: ProcessingJobName
    def processingResources
        : zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly]
    def appSpecification: zio.aws.sagemaker.model.AppSpecification.ReadOnly
    def environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]]
    def networkConfig: Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def getProcessingInputs: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProcessingInput.ReadOnly
    ]] = AwsError.unwrapOptionField("processingInputs", processingInputs)
    def getProcessingOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "processingOutputConfig",
      processingOutputConfig
    )
    def getProcessingJobName: ZIO[Any, Nothing, ProcessingJobName] =
      ZIO.succeed(processingJobName)
    def getProcessingResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ProcessingResources.ReadOnly
    ] = ZIO.succeed(processingResources)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getAppSpecification
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.AppSpecification.ReadOnly] =
      ZIO.succeed(appSpecification)
    def getEnvironment: ZIO[Any, AwsError, Map[
      ProcessingEnvironmentKey,
      ProcessingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
    def getNetworkConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NetworkConfig.ReadOnly] =
      AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest
  ) extends zio.aws.sagemaker.model.CreateProcessingJobRequest.ReadOnly {
    override val processingInputs
        : Option[List[zio.aws.sagemaker.model.ProcessingInput.ReadOnly]] = scala
      .Option(impl.processingInputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProcessingInput.wrap(item)
        }.toList
      )
    override val processingOutputConfig
        : Option[zio.aws.sagemaker.model.ProcessingOutputConfig.ReadOnly] =
      scala
        .Option(impl.processingOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingOutputConfig.wrap(value)
        )
    override val processingJobName: ProcessingJobName =
      zio.aws.sagemaker.model.primitives
        .ProcessingJobName(impl.processingJobName())
    override val processingResources
        : zio.aws.sagemaker.model.ProcessingResources.ReadOnly =
      zio.aws.sagemaker.model.ProcessingResources
        .wrap(impl.processingResources())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.ProcessingStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.ProcessingStoppingCondition.wrap(value)
        )
    override val appSpecification
        : zio.aws.sagemaker.model.AppSpecification.ReadOnly =
      zio.aws.sagemaker.model.AppSpecification.wrap(impl.appSpecification())
    override val environment
        : Option[Map[ProcessingEnvironmentKey, ProcessingEnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.ProcessingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .ProcessingEnvironmentValue(value)
            })
            .toMap
        )
    override val networkConfig
        : Option[zio.aws.sagemaker.model.NetworkConfig.ReadOnly] = scala
      .Option(impl.networkConfig())
      .map(value => zio.aws.sagemaker.model.NetworkConfig.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val experimentConfig
        : Option[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] = scala
      .Option(impl.experimentConfig())
      .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest
  ): zio.aws.sagemaker.model.CreateProcessingJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
