package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  RoleArn,
  PipelineDescription,
  PipelineDefinition,
  IdempotencyToken,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class CreatePipelineRequest(
    pipelineName: PipelineName,
    pipelineDisplayName: Option[PipelineName] = None,
    pipelineDefinition: Option[PipelineDefinition] = None,
    pipelineDefinitionS3Location: Option[
      zio.aws.sagemaker.model.PipelineDefinitionS3Location
    ] = None,
    pipelineDescription: Option[PipelineDescription] = None,
    clientRequestToken: IdempotencyToken,
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    parallelismConfiguration: Option[
      zio.aws.sagemaker.model.ParallelismConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(
        pipelineDisplayName.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineDisplayName)
      .optionallyWith(
        pipelineDefinition.map(value =>
          PipelineDefinition.unwrap(value): java.lang.String
        )
      )(_.pipelineDefinition)
      .optionallyWith(
        pipelineDefinitionS3Location.map(value => value.buildAwsValue())
      )(_.pipelineDefinitionS3Location)
      .optionallyWith(
        pipelineDescription.map(value =>
          PipelineDescription.unwrap(value): java.lang.String
        )
      )(_.pipelineDescription)
      .clientRequestToken(
        IdempotencyToken.unwrap(clientRequestToken): java.lang.String
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        parallelismConfiguration.map(value => value.buildAwsValue())
      )(_.parallelismConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreatePipelineRequest.ReadOnly =
    zio.aws.sagemaker.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreatePipelineRequest =
      zio.aws.sagemaker.model.CreatePipelineRequest(
        pipelineName,
        pipelineDisplayName.map(value => value),
        pipelineDefinition.map(value => value),
        pipelineDefinitionS3Location.map(value => value.asEditable),
        pipelineDescription.map(value => value),
        clientRequestToken,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parallelismConfiguration.map(value => value.asEditable)
      )
    def pipelineName: PipelineName
    def pipelineDisplayName: Option[PipelineName]
    def pipelineDefinition: Option[PipelineDefinition]
    def pipelineDefinitionS3Location
        : Option[zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly]
    def pipelineDescription: Option[PipelineDescription]
    def clientRequestToken: IdempotencyToken
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineDisplayName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineDisplayName", pipelineDisplayName)
    def getPipelineDefinition: ZIO[Any, AwsError, PipelineDefinition] =
      AwsError.unwrapOptionField("pipelineDefinition", pipelineDefinition)
    def getPipelineDefinitionS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineDefinitionS3Location",
      pipelineDefinitionS3Location
    )
    def getPipelineDescription: ZIO[Any, AwsError, PipelineDescription] =
      AwsError.unwrapOptionField("pipelineDescription", pipelineDescription)
    def getClientRequestToken: ZIO[Any, Nothing, IdempotencyToken] =
      ZIO.succeed(clientRequestToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getParallelismConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfiguration",
      parallelismConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest
  ) extends zio.aws.sagemaker.model.CreatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.sagemaker.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineDisplayName: Option[PipelineName] = scala
      .Option(impl.pipelineDisplayName())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val pipelineDefinition: Option[PipelineDefinition] = scala
      .Option(impl.pipelineDefinition())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDefinition(value)
      )
    override val pipelineDefinitionS3Location: Option[
      zio.aws.sagemaker.model.PipelineDefinitionS3Location.ReadOnly
    ] = scala
      .Option(impl.pipelineDefinitionS3Location())
      .map(value =>
        zio.aws.sagemaker.model.PipelineDefinitionS3Location.wrap(value)
      )
    override val pipelineDescription: Option[PipelineDescription] = scala
      .Option(impl.pipelineDescription())
      .map(value =>
        zio.aws.sagemaker.model.primitives.PipelineDescription(value)
      )
    override val clientRequestToken: IdempotencyToken =
      zio.aws.sagemaker.model.primitives
        .IdempotencyToken(impl.clientRequestToken())
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val parallelismConfiguration
        : Option[zio.aws.sagemaker.model.ParallelismConfiguration.ReadOnly] =
      scala
        .Option(impl.parallelismConfiguration())
        .map(value =>
          zio.aws.sagemaker.model.ParallelismConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest
  ): zio.aws.sagemaker.model.CreatePipelineRequest.ReadOnly = new Wrapper(impl)
}
