package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{RoleArn, MonitoringJobDefinitionName}
import scala.jdk.CollectionConverters.*
final case class CreateModelExplainabilityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName,
    modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig
    ] = None,
    modelExplainabilityAppSpecification: zio.aws.sagemaker.model.ModelExplainabilityAppSpecification,
    modelExplainabilityJobInput: zio.aws.sagemaker.model.ModelExplainabilityJobInput,
    modelExplainabilityJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest = {
    import CreateModelExplainabilityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .optionallyWith(
        modelExplainabilityBaselineConfig.map(value => value.buildAwsValue())
      )(_.modelExplainabilityBaselineConfig)
      .modelExplainabilityAppSpecification(
        modelExplainabilityAppSpecification.buildAwsValue()
      )
      .modelExplainabilityJobInput(modelExplainabilityJobInput.buildAwsValue())
      .modelExplainabilityJobOutputConfig(
        modelExplainabilityJobOutputConfig.buildAwsValue()
      )
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateModelExplainabilityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest =
      zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest(
        jobDefinitionName,
        modelExplainabilityBaselineConfig.map(value => value.asEditable),
        modelExplainabilityAppSpecification.asEditable,
        modelExplainabilityJobInput.asEditable,
        modelExplainabilityJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobDefinitionName: MonitoringJobDefinitionName
    def modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ]
    def modelExplainabilityAppSpecification
        : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly
    def modelExplainabilityJobInput
        : zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly
    def modelExplainabilityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getModelExplainabilityBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelExplainabilityBaselineConfig",
      modelExplainabilityBaselineConfig
    )
    def getModelExplainabilityAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly
    ] = ZIO.succeed(modelExplainabilityAppSpecification)
    def getModelExplainabilityJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly
    ] = ZIO.succeed(modelExplainabilityJobInput)
    def getModelExplainabilityJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(modelExplainabilityJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val modelExplainabilityBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.ReadOnly
    ] = scala
      .Option(impl.modelExplainabilityBaselineConfig())
      .map(value =>
        zio.aws.sagemaker.model.ModelExplainabilityBaselineConfig.wrap(value)
      )
    override val modelExplainabilityAppSpecification
        : zio.aws.sagemaker.model.ModelExplainabilityAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.ModelExplainabilityAppSpecification
        .wrap(impl.modelExplainabilityAppSpecification())
    override val modelExplainabilityJobInput
        : zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly =
      zio.aws.sagemaker.model.ModelExplainabilityJobInput
        .wrap(impl.modelExplainabilityJobInput())
    override val modelExplainabilityJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.modelExplainabilityJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest
  ): zio.aws.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
