package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{RoleArn, MonitoringJobDefinitionName}
import scala.jdk.CollectionConverters.*
final case class CreateModelBiasJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName,
    modelBiasBaselineConfig: Option[
      zio.aws.sagemaker.model.ModelBiasBaselineConfig
    ] = None,
    modelBiasAppSpecification: zio.aws.sagemaker.model.ModelBiasAppSpecification,
    modelBiasJobInput: zio.aws.sagemaker.model.ModelBiasJobInput,
    modelBiasJobOutputConfig: zio.aws.sagemaker.model.MonitoringOutputConfig,
    jobResources: zio.aws.sagemaker.model.MonitoringResources,
    networkConfig: Option[zio.aws.sagemaker.model.MonitoringNetworkConfig] =
      None,
    roleArn: RoleArn,
    stoppingCondition: Option[
      zio.aws.sagemaker.model.MonitoringStoppingCondition
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest = {
    import CreateModelBiasJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .optionallyWith(
        modelBiasBaselineConfig.map(value => value.buildAwsValue())
      )(_.modelBiasBaselineConfig)
      .modelBiasAppSpecification(modelBiasAppSpecification.buildAwsValue())
      .modelBiasJobInput(modelBiasJobInput.buildAwsValue())
      .modelBiasJobOutputConfig(modelBiasJobOutputConfig.buildAwsValue())
      .jobResources(jobResources.buildAwsValue())
      .optionallyWith(networkConfig.map(value => value.buildAwsValue()))(
        _.networkConfig
      )
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(stoppingCondition.map(value => value.buildAwsValue()))(
        _.stoppingCondition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest
      .wrap(buildAwsValue())
}
object CreateModelBiasJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest =
      zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest(
        jobDefinitionName,
        modelBiasBaselineConfig.map(value => value.asEditable),
        modelBiasAppSpecification.asEditable,
        modelBiasJobInput.asEditable,
        modelBiasJobOutputConfig.asEditable,
        jobResources.asEditable,
        networkConfig.map(value => value.asEditable),
        roleArn,
        stoppingCondition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def jobDefinitionName: MonitoringJobDefinitionName
    def modelBiasBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelBiasBaselineConfig.ReadOnly]
    def modelBiasAppSpecification
        : zio.aws.sagemaker.model.ModelBiasAppSpecification.ReadOnly
    def modelBiasJobInput: zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly
    def modelBiasJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    def jobResources: zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    def networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly]
    def roleArn: RoleArn
    def stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
    def getModelBiasBaselineConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelBiasBaselineConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "modelBiasBaselineConfig",
      modelBiasBaselineConfig
    )
    def getModelBiasAppSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelBiasAppSpecification.ReadOnly
    ] = ZIO.succeed(modelBiasAppSpecification)
    def getModelBiasJobInput: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly
    ] = ZIO.succeed(modelBiasJobInput)
    def getModelBiasJobOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly
    ] = ZIO.succeed(modelBiasJobOutputConfig)
    def getJobResources: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.MonitoringResources.ReadOnly
    ] = ZIO.succeed(jobResources)
    def getNetworkConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfig", networkConfig)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStoppingCondition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly
    ] = AwsError.unwrapOptionField("stoppingCondition", stoppingCondition)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
    override val modelBiasBaselineConfig
        : Option[zio.aws.sagemaker.model.ModelBiasBaselineConfig.ReadOnly] =
      scala
        .Option(impl.modelBiasBaselineConfig())
        .map(value =>
          zio.aws.sagemaker.model.ModelBiasBaselineConfig.wrap(value)
        )
    override val modelBiasAppSpecification
        : zio.aws.sagemaker.model.ModelBiasAppSpecification.ReadOnly =
      zio.aws.sagemaker.model.ModelBiasAppSpecification
        .wrap(impl.modelBiasAppSpecification())
    override val modelBiasJobInput
        : zio.aws.sagemaker.model.ModelBiasJobInput.ReadOnly =
      zio.aws.sagemaker.model.ModelBiasJobInput.wrap(impl.modelBiasJobInput())
    override val modelBiasJobOutputConfig
        : zio.aws.sagemaker.model.MonitoringOutputConfig.ReadOnly =
      zio.aws.sagemaker.model.MonitoringOutputConfig
        .wrap(impl.modelBiasJobOutputConfig())
    override val jobResources
        : zio.aws.sagemaker.model.MonitoringResources.ReadOnly =
      zio.aws.sagemaker.model.MonitoringResources.wrap(impl.jobResources())
    override val networkConfig
        : Option[zio.aws.sagemaker.model.MonitoringNetworkConfig.ReadOnly] =
      scala
        .Option(impl.networkConfig())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringNetworkConfig.wrap(value)
        )
    override val roleArn: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.roleArn())
    override val stoppingCondition
        : Option[zio.aws.sagemaker.model.MonitoringStoppingCondition.ReadOnly] =
      scala
        .Option(impl.stoppingCondition())
        .map(value =>
          zio.aws.sagemaker.model.MonitoringStoppingCondition.wrap(value)
        )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest
  ): zio.aws.sagemaker.model.CreateModelBiasJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
