package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.HyperParameterTuningJobName
import scala.jdk.CollectionConverters.*
final case class CreateHyperParameterTuningJobRequest(
    hyperParameterTuningJobName: HyperParameterTuningJobName,
    hyperParameterTuningJobConfig: zio.aws.sagemaker.model.HyperParameterTuningJobConfig,
    trainingJobDefinition: Option[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition
    ] = None,
    trainingJobDefinitions: Option[
      Iterable[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition]
    ] = None,
    warmStartConfig: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
    ] = None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest = {
    import CreateHyperParameterTuningJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
      .builder()
      .hyperParameterTuningJobName(
        HyperParameterTuningJobName.unwrap(
          hyperParameterTuningJobName
        ): java.lang.String
      )
      .hyperParameterTuningJobConfig(
        hyperParameterTuningJobConfig.buildAwsValue()
      )
      .optionallyWith(
        trainingJobDefinition.map(value => value.buildAwsValue())
      )(_.trainingJobDefinition)
      .optionallyWith(
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trainingJobDefinitions)
      .optionallyWith(warmStartConfig.map(value => value.buildAwsValue()))(
        _.warmStartConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly =
    zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest
      .wrap(buildAwsValue())
}
object CreateHyperParameterTuningJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest =
      zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest(
        hyperParameterTuningJobName,
        hyperParameterTuningJobConfig.asEditable,
        trainingJobDefinition.map(value => value.asEditable),
        trainingJobDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warmStartConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hyperParameterTuningJobName: HyperParameterTuningJobName
    def hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    def trainingJobDefinition: Option[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]
    def trainingJobDefinitions: Option[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ]
    def warmStartConfig: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def getHyperParameterTuningJobName
        : ZIO[Any, Nothing, HyperParameterTuningJobName] =
      ZIO.succeed(hyperParameterTuningJobName)
    def getHyperParameterTuningJobConfig: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly
    ] = ZIO.succeed(hyperParameterTuningJobConfig)
    def getTrainingJobDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] =
      AwsError.unwrapOptionField("trainingJobDefinition", trainingJobDefinition)
    def getTrainingJobDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trainingJobDefinitions",
      trainingJobDefinitions
    )
    def getWarmStartConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = AwsError.unwrapOptionField("warmStartConfig", warmStartConfig)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ) extends zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly {
    override val hyperParameterTuningJobName: HyperParameterTuningJobName =
      zio.aws.sagemaker.model.primitives
        .HyperParameterTuningJobName(impl.hyperParameterTuningJobName())
    override val hyperParameterTuningJobConfig
        : zio.aws.sagemaker.model.HyperParameterTuningJobConfig.ReadOnly =
      zio.aws.sagemaker.model.HyperParameterTuningJobConfig
        .wrap(impl.hyperParameterTuningJobConfig())
    override val trainingJobDefinition: Option[
      zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly
    ] = scala
      .Option(impl.trainingJobDefinition())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(value)
      )
    override val trainingJobDefinitions: Option[
      List[zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.ReadOnly]
    ] = scala
      .Option(impl.trainingJobDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTrainingJobDefinition.wrap(item)
        }.toList
      )
    override val warmStartConfig: Option[
      zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig.ReadOnly
    ] = scala
      .Option(impl.warmStartConfig())
      .map(value =>
        zio.aws.sagemaker.model.HyperParameterTuningJobWarmStartConfig
          .wrap(value)
      )
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest
  ): zio.aws.sagemaker.model.CreateHyperParameterTuningJobRequest.ReadOnly =
    new Wrapper(impl)
}
