package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  VersionedArnOrName,
  Url,
  EnvironmentKey,
  EnvironmentValue,
  InferenceSpecificationName,
  ContainerHostname,
  ContainerImage
}
import scala.jdk.CollectionConverters.*
final case class ContainerDefinition(
    containerHostname: Option[ContainerHostname] = None,
    image: Option[ContainerImage] = None,
    imageConfig: Option[zio.aws.sagemaker.model.ImageConfig] = None,
    mode: Option[zio.aws.sagemaker.model.ContainerMode] = None,
    modelDataUrl: Option[Url] = None,
    environment: Option[Map[EnvironmentKey, EnvironmentValue]] = None,
    modelPackageName: Option[VersionedArnOrName] = None,
    inferenceSpecificationName: Option[InferenceSpecificationName] = None,
    multiModelConfig: Option[zio.aws.sagemaker.model.MultiModelConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ContainerDefinition = {
    import ContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
      .builder()
      .optionallyWith(
        containerHostname.map(value =>
          ContainerHostname.unwrap(value): java.lang.String
        )
      )(_.containerHostname)
      .optionallyWith(
        image.map(value => ContainerImage.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(imageConfig.map(value => value.buildAwsValue()))(
        _.imageConfig
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        modelDataUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.modelDataUrl)
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (EnvironmentKey.unwrap(
                key
              ): java.lang.String) -> (EnvironmentValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .optionallyWith(
        modelPackageName.map(value =>
          VersionedArnOrName.unwrap(value): java.lang.String
        )
      )(_.modelPackageName)
      .optionallyWith(
        inferenceSpecificationName.map(value =>
          InferenceSpecificationName.unwrap(value): java.lang.String
        )
      )(_.inferenceSpecificationName)
      .optionallyWith(multiModelConfig.map(value => value.buildAwsValue()))(
        _.multiModelConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ContainerDefinition.ReadOnly =
    zio.aws.sagemaker.model.ContainerDefinition.wrap(buildAwsValue())
}
object ContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ContainerDefinition =
      zio.aws.sagemaker.model.ContainerDefinition(
        containerHostname.map(value => value),
        image.map(value => value),
        imageConfig.map(value => value.asEditable),
        mode.map(value => value),
        modelDataUrl.map(value => value),
        environment.map(value => value),
        modelPackageName.map(value => value),
        inferenceSpecificationName.map(value => value),
        multiModelConfig.map(value => value.asEditable)
      )
    def containerHostname: Option[ContainerHostname]
    def image: Option[ContainerImage]
    def imageConfig: Option[zio.aws.sagemaker.model.ImageConfig.ReadOnly]
    def mode: Option[zio.aws.sagemaker.model.ContainerMode]
    def modelDataUrl: Option[Url]
    def environment: Option[Map[EnvironmentKey, EnvironmentValue]]
    def modelPackageName: Option[VersionedArnOrName]
    def inferenceSpecificationName: Option[InferenceSpecificationName]
    def multiModelConfig
        : Option[zio.aws.sagemaker.model.MultiModelConfig.ReadOnly]
    def getContainerHostname: ZIO[Any, AwsError, ContainerHostname] =
      AwsError.unwrapOptionField("containerHostname", containerHostname)
    def getImage: ZIO[Any, AwsError, ContainerImage] =
      AwsError.unwrapOptionField("image", image)
    def getImageConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ImageConfig.ReadOnly] =
      AwsError.unwrapOptionField("imageConfig", imageConfig)
    def getMode: ZIO[Any, AwsError, zio.aws.sagemaker.model.ContainerMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getModelDataUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("modelDataUrl", modelDataUrl)
    def getEnvironment
        : ZIO[Any, AwsError, Map[EnvironmentKey, EnvironmentValue]] =
      AwsError.unwrapOptionField("environment", environment)
    def getModelPackageName: ZIO[Any, AwsError, VersionedArnOrName] =
      AwsError.unwrapOptionField("modelPackageName", modelPackageName)
    def getInferenceSpecificationName
        : ZIO[Any, AwsError, InferenceSpecificationName] =
      AwsError.unwrapOptionField(
        "inferenceSpecificationName",
        inferenceSpecificationName
      )
    def getMultiModelConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MultiModelConfig.ReadOnly
    ] = AwsError.unwrapOptionField("multiModelConfig", multiModelConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ) extends zio.aws.sagemaker.model.ContainerDefinition.ReadOnly {
    override val containerHostname: Option[ContainerHostname] = scala
      .Option(impl.containerHostname())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerHostname(value))
    override val image: Option[ContainerImage] = scala
      .Option(impl.image())
      .map(value => zio.aws.sagemaker.model.primitives.ContainerImage(value))
    override val imageConfig
        : Option[zio.aws.sagemaker.model.ImageConfig.ReadOnly] = scala
      .Option(impl.imageConfig())
      .map(value => zio.aws.sagemaker.model.ImageConfig.wrap(value))
    override val mode: Option[zio.aws.sagemaker.model.ContainerMode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.sagemaker.model.ContainerMode.wrap(value))
    override val modelDataUrl: Option[Url] = scala
      .Option(impl.modelDataUrl())
      .map(value => zio.aws.sagemaker.model.primitives.Url(value))
    override val environment: Option[Map[EnvironmentKey, EnvironmentValue]] =
      scala
        .Option(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.EnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.EnvironmentValue(value)
            })
            .toMap
        )
    override val modelPackageName: Option[VersionedArnOrName] = scala
      .Option(impl.modelPackageName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.VersionedArnOrName(value)
      )
    override val inferenceSpecificationName
        : Option[InferenceSpecificationName] = scala
      .Option(impl.inferenceSpecificationName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InferenceSpecificationName(value)
      )
    override val multiModelConfig
        : Option[zio.aws.sagemaker.model.MultiModelConfig.ReadOnly] = scala
      .Option(impl.multiModelConfig())
      .map(value => zio.aws.sagemaker.model.MultiModelConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ContainerDefinition
  ): zio.aws.sagemaker.model.ContainerDefinition.ReadOnly = new Wrapper(impl)
}
