package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{String1024, String256}
import scala.jdk.CollectionConverters.*
final case class ClarifyCheckStepMetadata(
    checkType: Option[String256] = None,
    baselineUsedForDriftCheckConstraints: Option[String1024] = None,
    calculatedBaselineConstraints: Option[String1024] = None,
    modelPackageGroupName: Option[String256] = None,
    violationReport: Option[String1024] = None,
    checkJobArn: Option[String256] = None,
    skipCheck: Option[Boolean] = None,
    registerNewBaseline: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata = {
    import ClarifyCheckStepMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata
      .builder()
      .optionallyWith(
        checkType.map(value => String256.unwrap(value): java.lang.String)
      )(_.checkType)
      .optionallyWith(
        baselineUsedForDriftCheckConstraints.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.baselineUsedForDriftCheckConstraints)
      .optionallyWith(
        calculatedBaselineConstraints.map(value =>
          String1024.unwrap(value): java.lang.String
        )
      )(_.calculatedBaselineConstraints)
      .optionallyWith(
        modelPackageGroupName.map(value =>
          String256.unwrap(value): java.lang.String
        )
      )(_.modelPackageGroupName)
      .optionallyWith(
        violationReport.map(value => String1024.unwrap(value): java.lang.String)
      )(_.violationReport)
      .optionallyWith(
        checkJobArn.map(value => String256.unwrap(value): java.lang.String)
      )(_.checkJobArn)
      .optionallyWith(skipCheck.map(value => value: java.lang.Boolean))(
        _.skipCheck
      )
      .optionallyWith(
        registerNewBaseline.map(value => value: java.lang.Boolean)
      )(_.registerNewBaseline)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly =
    zio.aws.sagemaker.model.ClarifyCheckStepMetadata.wrap(buildAwsValue())
}
object ClarifyCheckStepMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ClarifyCheckStepMetadata =
      zio.aws.sagemaker.model.ClarifyCheckStepMetadata(
        checkType.map(value => value),
        baselineUsedForDriftCheckConstraints.map(value => value),
        calculatedBaselineConstraints.map(value => value),
        modelPackageGroupName.map(value => value),
        violationReport.map(value => value),
        checkJobArn.map(value => value),
        skipCheck.map(value => value),
        registerNewBaseline.map(value => value)
      )
    def checkType: Option[String256]
    def baselineUsedForDriftCheckConstraints: Option[String1024]
    def calculatedBaselineConstraints: Option[String1024]
    def modelPackageGroupName: Option[String256]
    def violationReport: Option[String1024]
    def checkJobArn: Option[String256]
    def skipCheck: Option[Boolean]
    def registerNewBaseline: Option[Boolean]
    def getCheckType: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("checkType", checkType)
    def getBaselineUsedForDriftCheckConstraints
        : ZIO[Any, AwsError, String1024] = AwsError.unwrapOptionField(
      "baselineUsedForDriftCheckConstraints",
      baselineUsedForDriftCheckConstraints
    )
    def getCalculatedBaselineConstraints: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField(
        "calculatedBaselineConstraints",
        calculatedBaselineConstraints
      )
    def getModelPackageGroupName: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("modelPackageGroupName", modelPackageGroupName)
    def getViolationReport: ZIO[Any, AwsError, String1024] =
      AwsError.unwrapOptionField("violationReport", violationReport)
    def getCheckJobArn: ZIO[Any, AwsError, String256] =
      AwsError.unwrapOptionField("checkJobArn", checkJobArn)
    def getSkipCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipCheck", skipCheck)
    def getRegisterNewBaseline: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("registerNewBaseline", registerNewBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata
  ) extends zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly {
    override val checkType: Option[String256] = scala
      .Option(impl.checkType())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val baselineUsedForDriftCheckConstraints: Option[String1024] =
      scala
        .Option(impl.baselineUsedForDriftCheckConstraints())
        .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val calculatedBaselineConstraints: Option[String1024] = scala
      .Option(impl.calculatedBaselineConstraints())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val modelPackageGroupName: Option[String256] = scala
      .Option(impl.modelPackageGroupName())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val violationReport: Option[String1024] = scala
      .Option(impl.violationReport())
      .map(value => zio.aws.sagemaker.model.primitives.String1024(value))
    override val checkJobArn: Option[String256] = scala
      .Option(impl.checkJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.String256(value))
    override val skipCheck: Option[Boolean] =
      scala.Option(impl.skipCheck()).map(value => value: Boolean)
    override val registerNewBaseline: Option[Boolean] =
      scala.Option(impl.registerNewBaseline()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ClarifyCheckStepMetadata
  ): zio.aws.sagemaker.model.ClarifyCheckStepMetadata.ReadOnly = new Wrapper(
    impl
  )
}
