package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bias(
    report: Option[zio.aws.sagemaker.model.MetricsSource] = None,
    preTrainingReport: Option[zio.aws.sagemaker.model.MetricsSource] = None,
    postTrainingReport: Option[zio.aws.sagemaker.model.MetricsSource] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Bias = {
    import Bias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Bias
      .builder()
      .optionallyWith(report.map(value => value.buildAwsValue()))(_.report)
      .optionallyWith(preTrainingReport.map(value => value.buildAwsValue()))(
        _.preTrainingReport
      )
      .optionallyWith(postTrainingReport.map(value => value.buildAwsValue()))(
        _.postTrainingReport
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Bias.ReadOnly =
    zio.aws.sagemaker.model.Bias.wrap(buildAwsValue())
}
object Bias {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Bias] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Bias = zio.aws.sagemaker.model.Bias(
      report.map(value => value.asEditable),
      preTrainingReport.map(value => value.asEditable),
      postTrainingReport.map(value => value.asEditable)
    )
    def report: Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def preTrainingReport
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def postTrainingReport
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly]
    def getReport
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("report", report)
    def getPreTrainingReport
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("preTrainingReport", preTrainingReport)
    def getPostTrainingReport
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricsSource.ReadOnly] =
      AwsError.unwrapOptionField("postTrainingReport", postTrainingReport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Bias
  ) extends zio.aws.sagemaker.model.Bias.ReadOnly {
    override val report
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.report())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val preTrainingReport
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.preTrainingReport())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
    override val postTrainingReport
        : Option[zio.aws.sagemaker.model.MetricsSource.ReadOnly] = scala
      .Option(impl.postTrainingReport())
      .map(value => zio.aws.sagemaker.model.MetricsSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Bias
  ): zio.aws.sagemaker.model.Bias.ReadOnly = new Wrapper(impl)
}
