package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.EntityName
import scala.jdk.CollectionConverters.*
final case class UpdateCodeRepositoryRequest(
    codeRepositoryName: EntityName,
    gitConfig: Option[zio.aws.sagemaker.model.GitConfigForUpdate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest = {
    import UpdateCodeRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest
      .builder()
      .codeRepositoryName(
        EntityName.unwrap(codeRepositoryName): java.lang.String
      )
      .optionallyWith(gitConfig.map(value => value.buildAwsValue()))(
        _.gitConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UpdateCodeRepositoryRequest.ReadOnly =
    zio.aws.sagemaker.model.UpdateCodeRepositoryRequest.wrap(buildAwsValue())
}
object UpdateCodeRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UpdateCodeRepositoryRequest =
      zio.aws.sagemaker.model.UpdateCodeRepositoryRequest(
        codeRepositoryName,
        gitConfig.map(value => value.asEditable)
      )
    def codeRepositoryName: EntityName
    def gitConfig: Option[zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly]
    def getCodeRepositoryName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(codeRepositoryName)
    def getGitConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("gitConfig", gitConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest
  ) extends zio.aws.sagemaker.model.UpdateCodeRepositoryRequest.ReadOnly {
    override val codeRepositoryName: EntityName =
      zio.aws.sagemaker.model.primitives.EntityName(impl.codeRepositoryName())
    override val gitConfig
        : Option[zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly] = scala
      .Option(impl.gitConfig())
      .map(value => zio.aws.sagemaker.model.GitConfigForUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest
  ): zio.aws.sagemaker.model.UpdateCodeRepositoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
