package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{HumanTaskUiArn, S3Uri}
import scala.jdk.CollectionConverters.*
final case class UiConfig(
    uiTemplateS3Uri: Option[S3Uri] = None,
    humanTaskUiArn: Option[HumanTaskUiArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.UiConfig = {
    import UiConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.UiConfig
      .builder()
      .optionallyWith(
        uiTemplateS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.uiTemplateS3Uri)
      .optionallyWith(
        humanTaskUiArn.map(value =>
          HumanTaskUiArn.unwrap(value): java.lang.String
        )
      )(_.humanTaskUiArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.UiConfig.ReadOnly =
    zio.aws.sagemaker.model.UiConfig.wrap(buildAwsValue())
}
object UiConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.UiConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.UiConfig =
      zio.aws.sagemaker.model.UiConfig(
        uiTemplateS3Uri.map(value => value),
        humanTaskUiArn.map(value => value)
      )
    def uiTemplateS3Uri: Option[S3Uri]
    def humanTaskUiArn: Option[HumanTaskUiArn]
    def getUiTemplateS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("uiTemplateS3Uri", uiTemplateS3Uri)
    def getHumanTaskUiArn: ZIO[Any, AwsError, HumanTaskUiArn] =
      AwsError.unwrapOptionField("humanTaskUiArn", humanTaskUiArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.UiConfig
  ) extends zio.aws.sagemaker.model.UiConfig.ReadOnly {
    override val uiTemplateS3Uri: Option[S3Uri] = scala
      .Option(impl.uiTemplateS3Uri())
      .map(value => zio.aws.sagemaker.model.primitives.S3Uri(value))
    override val humanTaskUiArn: Option[HumanTaskUiArn] = scala
      .Option(impl.humanTaskUiArn())
      .map(value => zio.aws.sagemaker.model.primitives.HumanTaskUiArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.UiConfig
  ): zio.aws.sagemaker.model.UiConfig.ReadOnly = new Wrapper(impl)
}
