package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TenthFractionsOfACent,
  Cents,
  Dollars
}
import scala.jdk.CollectionConverters.*
final case class USD(
    dollars: Option[Dollars] = None,
    cents: Option[Cents] = None,
    tenthFractionsOfACent: Option[TenthFractionsOfACent] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.USD = {
    import USD.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.USD
      .builder()
      .optionallyWith(dollars.map(value => Dollars.unwrap(value): Integer))(
        _.dollars
      )
      .optionallyWith(cents.map(value => Cents.unwrap(value): Integer))(_.cents)
      .optionallyWith(
        tenthFractionsOfACent.map(value =>
          TenthFractionsOfACent.unwrap(value): Integer
        )
      )(_.tenthFractionsOfACent)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.USD.ReadOnly =
    zio.aws.sagemaker.model.USD.wrap(buildAwsValue())
}
object USD {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.USD] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.USD = zio.aws.sagemaker.model.USD(
      dollars.map(value => value),
      cents.map(value => value),
      tenthFractionsOfACent.map(value => value)
    )
    def dollars: Option[Dollars]
    def cents: Option[Cents]
    def tenthFractionsOfACent: Option[TenthFractionsOfACent]
    def getDollars: ZIO[Any, AwsError, Dollars] =
      AwsError.unwrapOptionField("dollars", dollars)
    def getCents: ZIO[Any, AwsError, Cents] =
      AwsError.unwrapOptionField("cents", cents)
    def getTenthFractionsOfACent: ZIO[Any, AwsError, TenthFractionsOfACent] =
      AwsError.unwrapOptionField("tenthFractionsOfACent", tenthFractionsOfACent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.USD
  ) extends zio.aws.sagemaker.model.USD.ReadOnly {
    override val dollars: Option[Dollars] = scala
      .Option(impl.dollars())
      .map(value => zio.aws.sagemaker.model.primitives.Dollars(value))
    override val cents: Option[Cents] = scala
      .Option(impl.cents())
      .map(value => zio.aws.sagemaker.model.primitives.Cents(value))
    override val tenthFractionsOfACent: Option[TenthFractionsOfACent] = scala
      .Option(impl.tenthFractionsOfACent())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TenthFractionsOfACent(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.USD
  ): zio.aws.sagemaker.model.USD.ReadOnly = new Wrapper(impl)
}
