package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.TrialComponentSourceArn
import scala.jdk.CollectionConverters.*
final case class TrialComponentSourceDetail(
    sourceArn: Option[TrialComponentSourceArn] = None,
    trainingJob: Option[zio.aws.sagemaker.model.TrainingJob] = None,
    processingJob: Option[zio.aws.sagemaker.model.ProcessingJob] = None,
    transformJob: Option[zio.aws.sagemaker.model.TransformJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail = {
    import TrialComponentSourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
      .builder()
      .optionallyWith(
        sourceArn.map(value =>
          TrialComponentSourceArn.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(trainingJob.map(value => value.buildAwsValue()))(
        _.trainingJob
      )
      .optionallyWith(processingJob.map(value => value.buildAwsValue()))(
        _.processingJob
      )
      .optionallyWith(transformJob.map(value => value.buildAwsValue()))(
        _.transformJob
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly =
    zio.aws.sagemaker.model.TrialComponentSourceDetail.wrap(buildAwsValue())
}
object TrialComponentSourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrialComponentSourceDetail =
      zio.aws.sagemaker.model.TrialComponentSourceDetail(
        sourceArn.map(value => value),
        trainingJob.map(value => value.asEditable),
        processingJob.map(value => value.asEditable),
        transformJob.map(value => value.asEditable)
      )
    def sourceArn: Option[TrialComponentSourceArn]
    def trainingJob: Option[zio.aws.sagemaker.model.TrainingJob.ReadOnly]
    def processingJob: Option[zio.aws.sagemaker.model.ProcessingJob.ReadOnly]
    def transformJob: Option[zio.aws.sagemaker.model.TransformJob.ReadOnly]
    def getSourceArn: ZIO[Any, AwsError, TrialComponentSourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getTrainingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrainingJob.ReadOnly] =
      AwsError.unwrapOptionField("trainingJob", trainingJob)
    def getProcessingJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProcessingJob.ReadOnly] =
      AwsError.unwrapOptionField("processingJob", processingJob)
    def getTransformJob
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TransformJob.ReadOnly] =
      AwsError.unwrapOptionField("transformJob", transformJob)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ) extends zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly {
    override val sourceArn: Option[TrialComponentSourceArn] = scala
      .Option(impl.sourceArn())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrialComponentSourceArn(value)
      )
    override val trainingJob
        : Option[zio.aws.sagemaker.model.TrainingJob.ReadOnly] = scala
      .Option(impl.trainingJob())
      .map(value => zio.aws.sagemaker.model.TrainingJob.wrap(value))
    override val processingJob
        : Option[zio.aws.sagemaker.model.ProcessingJob.ReadOnly] = scala
      .Option(impl.processingJob())
      .map(value => zio.aws.sagemaker.model.ProcessingJob.wrap(value))
    override val transformJob
        : Option[zio.aws.sagemaker.model.TransformJob.ReadOnly] = scala
      .Option(impl.transformJob())
      .map(value => zio.aws.sagemaker.model.TransformJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail
  ): zio.aws.sagemaker.model.TrialComponentSourceDetail.ReadOnly = new Wrapper(
    impl
  )
}
