package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  TrialArn,
  ExperimentEntityName
}
import scala.jdk.CollectionConverters.*
final case class Trial(
    trialName: Option[ExperimentEntityName] = None,
    trialArn: Option[TrialArn] = None,
    displayName: Option[ExperimentEntityName] = None,
    experimentName: Option[ExperimentEntityName] = None,
    source: Option[zio.aws.sagemaker.model.TrialSource] = None,
    creationTime: Option[Timestamp] = None,
    createdBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    lastModifiedTime: Option[Timestamp] = None,
    lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext] = None,
    metadataProperties: Option[zio.aws.sagemaker.model.MetadataProperties] =
      None,
    tags: Option[Iterable[zio.aws.sagemaker.model.Tag]] = None,
    trialComponentSummaries: Option[
      Iterable[zio.aws.sagemaker.model.TrialComponentSimpleSummary]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Trial = {
    import Trial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Trial
      .builder()
      .optionallyWith(
        trialName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialName)
      .optionallyWith(
        trialArn.map(value => TrialArn.unwrap(value): java.lang.String)
      )(_.trialArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        experimentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.experimentName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trialComponentSummaries)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Trial.ReadOnly =
    zio.aws.sagemaker.model.Trial.wrap(buildAwsValue())
}
object Trial {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Trial] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Trial =
      zio.aws.sagemaker.model.Trial(
        trialName.map(value => value),
        trialArn.map(value => value),
        displayName.map(value => value),
        experimentName.map(value => value),
        source.map(value => value.asEditable),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        metadataProperties.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trialComponentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trialName: Option[ExperimentEntityName]
    def trialArn: Option[TrialArn]
    def displayName: Option[ExperimentEntityName]
    def experimentName: Option[ExperimentEntityName]
    def source: Option[zio.aws.sagemaker.model.TrialSource.ReadOnly]
    def creationTime: Option[Timestamp]
    def createdBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Option[Timestamp]
    def lastModifiedBy: Option[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]]
    def trialComponentSummaries: Option[
      List[zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly]
    ]
    def getTrialName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialName", trialName)
    def getTrialArn: ZIO[Any, AwsError, TrialArn] =
      AwsError.unwrapOptionField("trialArn", trialArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getExperimentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("experimentName", experimentName)
    def getSource
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTrialComponentSummaries: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "trialComponentSummaries",
      trialComponentSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Trial
  ) extends zio.aws.sagemaker.model.Trial.ReadOnly {
    override val trialName: Option[ExperimentEntityName] = scala
      .Option(impl.trialName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val trialArn: Option[TrialArn] = scala
      .Option(impl.trialArn())
      .map(value => zio.aws.sagemaker.model.primitives.TrialArn(value))
    override val displayName: Option[ExperimentEntityName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val experimentName: Option[ExperimentEntityName] = scala
      .Option(impl.experimentName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
      )
    override val source: Option[zio.aws.sagemaker.model.TrialSource.ReadOnly] =
      scala
        .Option(impl.source())
        .map(value => zio.aws.sagemaker.model.TrialSource.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.createdBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Option[zio.aws.sagemaker.model.UserContext.ReadOnly] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val metadataProperties
        : Option[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] = scala
      .Option(impl.metadataProperties())
      .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val tags: Option[List[zio.aws.sagemaker.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Tag.wrap(item)
          }.toList
        )
    override val trialComponentSummaries: Option[
      List[zio.aws.sagemaker.model.TrialComponentSimpleSummary.ReadOnly]
    ] = scala
      .Option(impl.trialComponentSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialComponentSimpleSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Trial
  ): zio.aws.sagemaker.model.Trial.ReadOnly = new Wrapper(impl)
}
