package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  Timestamp,
  StudioLifecycleConfigName,
  StudioLifecycleConfigArn
}
import scala.jdk.CollectionConverters.*
final case class StudioLifecycleConfigDetails(
    studioLifecycleConfigArn: Option[StudioLifecycleConfigArn] = None,
    studioLifecycleConfigName: Option[StudioLifecycleConfigName] = None,
    creationTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    studioLifecycleConfigAppType: Option[
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails = {
    import StudioLifecycleConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails
      .builder()
      .optionallyWith(
        studioLifecycleConfigArn.map(value =>
          StudioLifecycleConfigArn.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigArn)
      .optionallyWith(
        studioLifecycleConfigName.map(value =>
          StudioLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.studioLifecycleConfigName)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(studioLifecycleConfigAppType.map(value => value.unwrap))(
        _.studioLifecycleConfigAppType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly =
    zio.aws.sagemaker.model.StudioLifecycleConfigDetails.wrap(buildAwsValue())
}
object StudioLifecycleConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StudioLifecycleConfigDetails =
      zio.aws.sagemaker.model.StudioLifecycleConfigDetails(
        studioLifecycleConfigArn.map(value => value),
        studioLifecycleConfigName.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        studioLifecycleConfigAppType.map(value => value)
      )
    def studioLifecycleConfigArn: Option[StudioLifecycleConfigArn]
    def studioLifecycleConfigName: Option[StudioLifecycleConfigName]
    def creationTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def studioLifecycleConfigAppType
        : Option[zio.aws.sagemaker.model.StudioLifecycleConfigAppType]
    def getStudioLifecycleConfigArn
        : ZIO[Any, AwsError, StudioLifecycleConfigArn] = AwsError
      .unwrapOptionField("studioLifecycleConfigArn", studioLifecycleConfigArn)
    def getStudioLifecycleConfigName
        : ZIO[Any, AwsError, StudioLifecycleConfigName] = AwsError
      .unwrapOptionField("studioLifecycleConfigName", studioLifecycleConfigName)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getStudioLifecycleConfigAppType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.StudioLifecycleConfigAppType
    ] = AwsError.unwrapOptionField(
      "studioLifecycleConfigAppType",
      studioLifecycleConfigAppType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails
  ) extends zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly {
    override val studioLifecycleConfigArn: Option[StudioLifecycleConfigArn] =
      scala
        .Option(impl.studioLifecycleConfigArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.StudioLifecycleConfigArn(value)
        )
    override val studioLifecycleConfigName: Option[StudioLifecycleConfigName] =
      scala
        .Option(impl.studioLifecycleConfigName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.StudioLifecycleConfigName(value)
        )
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val studioLifecycleConfigAppType
        : Option[zio.aws.sagemaker.model.StudioLifecycleConfigAppType] = scala
      .Option(impl.studioLifecycleConfigAppType())
      .map(value =>
        zio.aws.sagemaker.model.StudioLifecycleConfigAppType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails
  ): zio.aws.sagemaker.model.StudioLifecycleConfigDetails.ReadOnly =
    new Wrapper(impl)
}
