package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait SplitType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.SplitType
}
object SplitType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.SplitType
  ): zio.aws.sagemaker.model.SplitType = value match {
    case software.amazon.awssdk.services.sagemaker.model.SplitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.SplitType.NONE =>
      val r = None
      r
    case software.amazon.awssdk.services.sagemaker.model.SplitType.LINE =>
      val r = Line
      r
    case software.amazon.awssdk.services.sagemaker.model.SplitType.RECORD_IO =>
      val r = RecordIO
      r
    case software.amazon.awssdk.services.sagemaker.model.SplitType.TF_RECORD =>
      val r = TFRecord
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.SplitType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SplitType =
      software.amazon.awssdk.services.sagemaker.model.SplitType.UNKNOWN_TO_SDK_VERSION
  }
  case object None extends zio.aws.sagemaker.model.SplitType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SplitType =
      software.amazon.awssdk.services.sagemaker.model.SplitType.NONE
  }
  case object Line extends zio.aws.sagemaker.model.SplitType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SplitType =
      software.amazon.awssdk.services.sagemaker.model.SplitType.LINE
  }
  case object RecordIO extends zio.aws.sagemaker.model.SplitType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SplitType =
      software.amazon.awssdk.services.sagemaker.model.SplitType.RECORD_IO
  }
  case object TFRecord extends zio.aws.sagemaker.model.SplitType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.SplitType =
      software.amazon.awssdk.services.sagemaker.model.SplitType.TF_RECORD
  }
}
