package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.ResourcePropertyName
import scala.jdk.CollectionConverters.*
final case class PropertyNameSuggestion(
    propertyName: Option[ResourcePropertyName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion = {
    import PropertyNameSuggestion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion
      .builder()
      .optionallyWith(
        propertyName.map(value =>
          ResourcePropertyName.unwrap(value): java.lang.String
        )
      )(_.propertyName)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly =
    zio.aws.sagemaker.model.PropertyNameSuggestion.wrap(buildAwsValue())
}
object PropertyNameSuggestion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.PropertyNameSuggestion =
      zio.aws.sagemaker.model
        .PropertyNameSuggestion(propertyName.map(value => value))
    def propertyName: Option[ResourcePropertyName]
    def getPropertyName: ZIO[Any, AwsError, ResourcePropertyName] =
      AwsError.unwrapOptionField("propertyName", propertyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion
  ) extends zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly {
    override val propertyName: Option[ResourcePropertyName] = scala
      .Option(impl.propertyName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.ResourcePropertyName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.PropertyNameSuggestion
  ): zio.aws.sagemaker.model.PropertyNameSuggestion.ReadOnly = new Wrapper(impl)
}
